// Creates w_jles2000 w_jles2000 - current and last job Employment Status 2000.
// INPUT FILE - w_indresp.dta (Special Licence data required to generate the variables) 
// OUTPUT FILE - w_es2000_dv.dta

// WRITE FILEPATH WHERE YOU HAVE DOWNLOADED THE DATA
global in ""
// WRITE FILEPATH WHERE YOU WOULD LIKE TO SAVE THE OUTPUT FILE
global outpath ""


// 1 is for BHPS, 2 is for UKHLS
global cohort "2" 

foreach w in a b c d e f g h i j k l { // INCLUDE WAVE LETTERS FOR THE WAVES NEEDED
global wave "`w'_"
global num=strpos("abcdefghijklmnopqrstuvwxyz","`w'")
global dta ""
global waveno=$num
global inpath "${in}/bhps_w${num}"
if $cohort==2 {
	global waveno=$num+18	
	global inpath "${in}/ukhls"
}


use "${outpath}/${wave}indresp", clear


drop ${wave}jbes2000 ${wave}jles2000
label drop ${wave}jbes2000 ${wave}jles2000
foreach var in jbsize jssize jbmngr jbsemp jbhas jboff jsboss ivfio jlsize jlmngr jlsemp  jlboss jbhad{ 
rename ${wave}`var' `var'
}

/*-------------ORIGINAL CODE--------------*/
/* This code derives ES 2000						
// first step is to impute some missing values according to rules laid out in the document titled
// "The National Statistics Socio-economic Classification". Date consulted 4 September 2012. 
// Note that jbsize was not collected in the proxy questionnaire so imputation will disproportionately apply to 
// proxy interviewees in employment. They may appear to be working in small organisations at a higher rate than
// had the information been collected rather than imputed.
*/
// standard imputations
for var jbsize jssize jbmngr jbsemp: recode X (-9=-8) if (jbhas~=1 & jboff~=1)
recode jssize (-9 -2 -1=11)  // if missing then assume size of organisation is 1-24
recode jbsize (-9 -2 -1=11)  // if missing then assume size of organisation is 1-24
recode jbsize (-7 =11) if ivfio==2    // jbsize was inapplicable to proxy respondents, so impute 
gen help=(${wave}jbsoc00==1|(${wave}jbsoc00>=10 & ${wave}jbsoc00<20)|(${wave}jbsoc00>=100 & ${wave}jbsoc00<200) ///
         |(${wave}jbsoc00>=1000 & ${wave}jbsoc00<2000)) // if codes are at less fine level
recode jbmngr (-9 -2 -1=1) if help==1    // assume manager if Soc2000 starts with 1.
recode jbmngr (-9 -2 -1=3) if help==0    // assume not manager/supervisor if SOC2000 does not start with 1
recode jssize (-9 -2 -1=1)			     // assume no employess if information is missing
drop help

recode jlsize (-9 -2 -1=11)  // if missing then assume size of organisation is 1-24
gen help=(${wave}jlsoc00==1|(${wave}jlsoc00>=10 & ${wave}jlsoc00<20)|(${wave}jlsoc00>=100 & ${wave}jlsoc00<200) ///
         |(${wave}jlsoc00>=1000 & ${wave}jlsoc00<2000))
recode jlmngr (-9 -2 -1=1) if help==1    // assume manager if Soc2000 starts with 1.
recode jlmngr (-9 -2 -1=3) if help==0    // assume not manager/supervisor if SOC2000 does not start with 1
recode jlsize (-9 -2 -1=1)			     // assume no employess if information is missing
capture drop es2000_jl
drop help

gen ${wave}jbes2000=-9
replace ${wave}jbes2000=	1	if jbsemp==	2	& jssize==	4	& jsboss==	1					
replace ${wave}jbes2000=	1	if jbsemp==	2	& jssize==	5	& jsboss==	1					
replace ${wave}jbes2000=	1	if jbsemp==	2	& jssize==	6	& jsboss==	1					
replace ${wave}jbes2000=	1	if jbsemp==	2	& jssize==	7	& jsboss==	1					
replace ${wave}jbes2000=	1	if jbsemp==	2	& jssize==	8	& jsboss==	1					
replace ${wave}jbes2000=	1	if jbsemp==	2	& jssize==	9	& jsboss==	1	
replace ${wave}jbes2000=	1	if jbsemp==	2	& jssize==	11	& jsboss==	1					
replace ${wave}jbes2000=	2	if jbsemp==	2	& jssize==	1	& jsboss==	1					
replace ${wave}jbes2000=	2	if jbsemp==	2	& jssize==	2	& jsboss==	1					
replace ${wave}jbes2000=	2	if jbsemp==	2	& jssize==	3	& jsboss==	1					
replace ${wave}jbes2000=	2	if jbsemp==	2	& jssize==	10	& jsboss==	1					
replace ${wave}jbes2000=	3	if jbsemp==	2	& jsboss==	2					
replace ${wave}jbes2000=	4	if jbsemp==	1	& jbsize==	4	& jbmngr==	1	
replace ${wave}jbes2000=	4	if jbsemp==	1	& jbsize==	5	& jbmngr==	1	
replace ${wave}jbes2000=	4	if jbsemp==	1	& jbsize==	6	& jbmngr==	1	
replace ${wave}jbes2000=	4	if jbsemp==	1	& jbsize==	7	& jbmngr==	1	
replace ${wave}jbes2000=	4	if jbsemp==	1	& jbsize==	8	& jbmngr==	1	
replace ${wave}jbes2000=	4	if jbsemp==	1	& jbsize==	9	& jbmngr==	1
replace ${wave}jbes2000=	4	if jbsemp==	1	& jbsize==	11	& jbmngr==	1	
replace ${wave}jbes2000=	5	if jbsemp==	1	& jbsize==	1	& jbmngr==	1	
replace ${wave}jbes2000=	5	if jbsemp==	1	& jbsize==	2	& jbmngr==	1	
replace ${wave}jbes2000=	5	if jbsemp==	1	& jbsize==	3	& jbmngr==	1	
replace ${wave}jbes2000=	5	if jbsemp==	1	& jbsize==	10	& jbmngr==	1	
replace ${wave}jbes2000=	6	if jbsemp==	1				    & jbmngr==	2	
replace ${wave}jbes2000=	7	if jbsemp==	1					& jbmngr==	3
//replace ${wave}jbes2000=-8 if ${wave}jbes2000==-9 //added PM
replace ${wave}jbes2000=-8 if  jbhas~=1 & jboff~=1

gen ${wave}jles2000=-9											
replace ${wave}jles2000=1	if jlsemp==	2	& jlsize==	4	& jlboss==	1				
replace ${wave}jles2000=1	if jlsemp==	2	& jlsize==	5	& jlboss==	1				
replace ${wave}jles2000=1	if jlsemp==	2	& jlsize==	6	& jlboss==	1				
replace ${wave}jles2000=1	if jlsemp==	2	& jlsize==	7	& jlboss==	1				
replace ${wave}jles2000=1	if jlsemp==	2	& jlsize==	8	& jlboss==	1				
replace ${wave}jles2000=1	if jlsemp==	2	& jlsize==	9	& jlboss==	1
replace ${wave}jles2000=1	if jlsemp==	2	& jlsize==	11	& jlboss==	1				
replace ${wave}jles2000=2	if jlsemp==	2	& jlsize==	1	& jlboss==	1				
replace ${wave}jles2000=2	if jlsemp==	2	& jlsize==	2	& jlboss==	1				
replace ${wave}jles2000=2	if jlsemp==	2	& jlsize==	3	& jlboss==	1				
replace ${wave}jles2000=2	if jlsemp==	2	& jlsize==	10	& jlboss==	1				
replace ${wave}jles2000=3	if jlsemp==	2	& jlboss==	2				
replace ${wave}jles2000=4	if jlsemp==	1	& jlsize==	4	& jlmngr==	1
replace ${wave}jles2000=4	if jlsemp==	1	& jlsize==	5	& jlmngr==	1
replace ${wave}jles2000=4	if jlsemp==	1	& jlsize==	6	& jlmngr==	1
replace ${wave}jles2000=4	if jlsemp==	1	& jlsize==	7	& jlmngr==	1
replace ${wave}jles2000=4	if jlsemp==	1	& jlsize==	8	& jlmngr==	1
replace ${wave}jles2000=4	if jlsemp==	1	& jlsize==	9	& jlmngr==	1
replace ${wave}jles2000=4	if jlsemp==	1	& jlsize==	11	& jlmngr==	1
replace ${wave}jles2000=5	if jlsemp==	1	& jlsize==	1	& jlmngr==	1
replace ${wave}jles2000=5	if jlsemp==	1	& jlsize==	2	& jlmngr==	1
replace ${wave}jles2000=5	if jlsemp==	1	& jlsize==	3	& jlmngr==	1
replace ${wave}jles2000=5	if jlsemp==	1	& jlsize==	10	& jlmngr==	1
replace ${wave}jles2000=6	if jlsemp==	1					& jlmngr==	2
replace ${wave}jles2000=7	if jlsemp==	1	                & jlmngr==	3

// Assign correct missing values
for var ${wave}jb* ${wave}jl*: recode X (.=-9)
for var ${wave}jb*: recode X (. -7 -9=-8) if jbhas~=1 & jboff~=1
for var ${wave}jl*: recode X (. -9=-8) if jbhad~=1 
// there are some codes for people who were not supposed to have last job info
for var ${wave}jl*: replace X =-8 if (jbhas~=2 & jboff~=2 & jbhad~=1)	
for var ${wave}jl*: recode X (. -9/-8=-7) if ivfio==2
keep pidp ${wave}jbes2000 ${wave}jles2000
lab var ${wave}jbes2000 "Current job: Employment Status 2000"
lab var ${wave}jles2000 "Last job: Employment Status 2000"
do "$outpath/es2000_lb"
save "$outpath/${wave}es2000_dv", replace
}


