// Creates w_jbisco88, w_jbisco88_cc, w_jlisco88, w_jlisco88_cc - ISCO version of the current and last job occupation variables.
// INPUT FILE - w_indresp.dta (special licence required to generate non-condensed variables) 
// OUTPUT FILE - w_isco88.dta

// WRITE FILEPATH WHERE YOU HAVE DOWNLOADED THE DATA
global in ""
// WRITE FILEPATH WHERE YOU WOULD LIKE TO SAVE THE OUTPUT FILE
global outpath ""

// 1 is for BHPS, 2 is for UKHLS
global cohort "2" 

foreach w in a b c d e f g h i j k l { // INCLUDE WAVE LETTERS FOR THE WAVES NEEDED
global wave "`w'_"
global num=strpos("abcdefghijklmnopqrstuvwxyz","`w'")
global dta ""
global waveno=$num
global inpath "${in}/bhps_w${num}"
if $cohort==2 {
	global waveno=$num+18	
	global inpath "${in}/ukhls"

	}

use  "$inpath/${wave}indresp", clear


drop ${wave}jbisco88 ${wave}jlisco88
rename ${wave}jbsemp jbsemp
rename ${wave}jlsemp jlsemp
rename ${wave}jbsize jbsize
rename ${wave}jssize jssize
rename ${wave}jlsize jlsize
rename ${wave}jbhad jbhad
rename ${wave}jbhas jbhas
rename ${wave}jboff jboff
rename ${wave}ivfio ivfio

// generate ISCO88 from look-up file SOC2000 to ISCO88
foreach st in b l {
gen ${wave}j`st'isco88=	-9								
replace ${wave}j`st'isco88=	1110	if ${wave}j`st'soc00==	1111						
replace ${wave}j`st'isco88=	1210	if ${wave}j`st'soc00==	1112						
replace ${wave}j`st'isco88=	1110	if ${wave}j`st'soc00==	1113						
replace ${wave}j`st'isco88=	1140	if ${wave}j`st'soc00==	1114						
replace ${wave}j`st'isco88=	1222	if ${wave}j`st'soc00==	1123						
replace ${wave}j`st'isco88=	1231	if ${wave}j`st'soc00==	1131						
replace ${wave}j`st'isco88=	1233	if ${wave}j`st'soc00==	1132						
replace ${wave}j`st'isco88=	1235	if ${wave}j`st'soc00==	1133						
replace ${wave}j`st'isco88=	1234	if ${wave}j`st'soc00==	1134						
replace ${wave}j`st'isco88=	1232	if ${wave}j`st'soc00==	1135						
replace ${wave}j`st'isco88=	1236	if ${wave}j`st'soc00==	1136						
replace ${wave}j`st'isco88=	1237	if ${wave}j`st'soc00==	1137						
replace ${wave}j`st'isco88=	1239	if ${wave}j`st'soc00==	1141						
replace ${wave}j`st'isco88=	1239	if ${wave}j`st'soc00==	1142						
replace ${wave}j`st'isco88=	1312	if ${wave}j`st'soc00==	1121	& j`st'semp==	1	& j`st'size==	1
replace ${wave}j`st'isco88=	1312	if ${wave}j`st'soc00==	1121	& j`st'semp==	1	& j`st'size==	2
replace ${wave}j`st'isco88=	1222	if ${wave}j`st'soc00==	1121	& j`st'semp==	1	& j`st'size==	3
replace ${wave}j`st'isco88=	1222	if ${wave}j`st'soc00==	1121	& j`st'semp==	1	& j`st'size==	4
replace ${wave}j`st'isco88=	1222	if ${wave}j`st'soc00==	1121	& j`st'semp==	1			& j`st'size==	5
replace ${wave}j`st'isco88=	1222	if ${wave}j`st'soc00==	1121	& j`st'semp==	1			& j`st'size==	6
replace ${wave}j`st'isco88=	1222	if ${wave}j`st'soc00==	1121	& j`st'semp==	1			& j`st'size==	7
replace ${wave}j`st'isco88=	1222	if ${wave}j`st'soc00==	1121	& j`st'semp==	1			& j`st'size==	8
replace ${wave}j`st'isco88=	1222	if ${wave}j`st'soc00==	1121	& j`st'semp==	1			& j`st'size==	9
replace ${wave}j`st'isco88=	1222	if ${wave}j`st'soc00==	1121	& j`st'semp==	1			& j`st'size==	10
replace ${wave}j`st'isco88=	-8	if ${wave}j`st'soc00==	1121	& j`st'semp==	1			& j`st'size==	11
replace ${wave}j`st'isco88=	-8	if ${wave}j`st'soc00==	1121	& j`st'semp==	1			& j`st'size==	-8
replace ${wave}j`st'isco88=	-8	if ${wave}j`st'soc00==	1121	& j`st'semp==	1			& j`st'size==	-2
replace ${wave}j`st'isco88=	-8	if ${wave}j`st'soc00==	1121	& j`st'semp==	1			& j`st'size==	-1
replace ${wave}j`st'isco88=	1312	if ${wave}j`st'soc00==	1121	& j`st'semp==	2	& jssize==	1		
replace ${wave}j`st'isco88=	1312	if ${wave}j`st'soc00==	1121	& j`st'semp==	2	& jssize==	2		
replace ${wave}j`st'isco88=	1222	if ${wave}j`st'soc00==	1121	& j`st'semp==	2	& jssize==	3		
replace ${wave}j`st'isco88=	1222	if ${wave}j`st'soc00==	1121	& j`st'semp==	2	& jssize==	4		
replace ${wave}j`st'isco88=	1222	if ${wave}j`st'soc00==	1121	& j`st'semp==	2	& jssize==	5		
replace ${wave}j`st'isco88=	1222	if ${wave}j`st'soc00==	1121	& j`st'semp==	2	& jssize==	6		
replace ${wave}j`st'isco88=	1222	if ${wave}j`st'soc00==	1121	& j`st'semp==	2	& jssize==	7		
replace ${wave}j`st'isco88=	1222	if ${wave}j`st'soc00==	1121	& j`st'semp==	2	& jssize==	8		
replace ${wave}j`st'isco88=	1222	if ${wave}j`st'soc00==	1121	& j`st'semp==	2	& jssize==	9		
replace ${wave}j`st'isco88=	1222	if ${wave}j`st'soc00==	1121	& j`st'semp==	2	& jssize==	10		
replace ${wave}j`st'isco88=	-8	if ${wave}j`st'soc00==	1121	& j`st'semp==	2	& jssize==	11		
replace ${wave}j`st'isco88=	-8	if ${wave}j`st'soc00==	1121	& j`st'semp==	2	& jssize==	-8		
replace ${wave}j`st'isco88=	-8	if ${wave}j`st'soc00==	1121	& j`st'semp==	2	& jssize==	-9		
replace ${wave}j`st'isco88=	1313	if ${wave}j`st'soc00==	1122	& j`st'semp==	1			& j`st'size==	1
replace ${wave}j`st'isco88=	1313	if ${wave}j`st'soc00==	1122	& j`st'semp==	1			& j`st'size==	2
replace ${wave}j`st'isco88=	1223	if ${wave}j`st'soc00==	1122	& j`st'semp==	1			& j`st'size==	3
replace ${wave}j`st'isco88=	1223	if ${wave}j`st'soc00==	1122	& j`st'semp==	1			& j`st'size==	4
replace ${wave}j`st'isco88=	1223	if ${wave}j`st'soc00==	1122	& j`st'semp==	1			& j`st'size==	5
replace ${wave}j`st'isco88=	1223	if ${wave}j`st'soc00==	1122	& j`st'semp==	1			& j`st'size==	6
replace ${wave}j`st'isco88=	1223	if ${wave}j`st'soc00==	1122	& j`st'semp==	1			& j`st'size==	7
replace ${wave}j`st'isco88=	1223	if ${wave}j`st'soc00==	1122	& j`st'semp==	1			& j`st'size==	8
replace ${wave}j`st'isco88=	1223	if ${wave}j`st'soc00==	1122	& j`st'semp==	1			& j`st'size==	9
replace ${wave}j`st'isco88=	1223	if ${wave}j`st'soc00==	1122	& j`st'semp==	1			& j`st'size==	10
replace ${wave}j`st'isco88=	-8	if ${wave}j`st'soc00==	1122	& j`st'semp==	1			& j`st'size==	11
replace ${wave}j`st'isco88=	-8	if ${wave}j`st'soc00==	1122	& j`st'semp==	1			& j`st'size==	-8
replace ${wave}j`st'isco88=	-8	if ${wave}j`st'soc00==	1122	& j`st'semp==	1			& j`st'size==	-2
replace ${wave}j`st'isco88=	-8	if ${wave}j`st'soc00==	1122	& j`st'semp==	1			& j`st'size==	-1
replace ${wave}j`st'isco88=	1313	if ${wave}j`st'soc00==	1122	& j`st'semp==	2	& jssize==	1		
replace ${wave}j`st'isco88=	1313	if ${wave}j`st'soc00==	1122	& j`st'semp==	2	& jssize==	2		
replace ${wave}j`st'isco88=	1223	if ${wave}j`st'soc00==	1122	& j`st'semp==	2	& jssize==	3		
replace ${wave}j`st'isco88=	1223	if ${wave}j`st'soc00==	1122	& j`st'semp==	2	& jssize==	4		
replace ${wave}j`st'isco88=	1223	if ${wave}j`st'soc00==	1122	& j`st'semp==	2	& jssize==	5		
replace ${wave}j`st'isco88=	1223	if ${wave}j`st'soc00==	1122	& j`st'semp==	2	& jssize==	6		
replace ${wave}j`st'isco88=	1223	if ${wave}j`st'soc00==	1122	& j`st'semp==	2	& jssize==	7		
replace ${wave}j`st'isco88=	1223	if ${wave}j`st'soc00==	1122	& j`st'semp==	2	& jssize==	8		
replace ${wave}j`st'isco88=	1223	if ${wave}j`st'soc00==	1122	& j`st'semp==	2	& jssize==	9		
replace ${wave}j`st'isco88=	1223	if ${wave}j`st'soc00==	1122	& j`st'semp==	2	& jssize==	10		
replace ${wave}j`st'isco88=	-8	if ${wave}j`st'soc00==	1122	& j`st'semp==	2	& jssize==	11		
replace ${wave}j`st'isco88=	-8	if ${wave}j`st'soc00==	1122	& j`st'semp==	2	& jssize==	-8		
replace ${wave}j`st'isco88=	-8	if ${wave}j`st'soc00==	1122	& j`st'semp==	2	& jssize==	-9		
replace ${wave}j`st'isco88=	1317	if ${wave}j`st'soc00==	1151	& j`st'semp==	1			& j`st'size==	1
replace ${wave}j`st'isco88=	1317	if ${wave}j`st'soc00==	1151	& j`st'semp==	1			& j`st'size==	2
replace ${wave}j`st'isco88=	1227	if ${wave}j`st'soc00==	1151	& j`st'semp==	1			& j`st'size==	3
replace ${wave}j`st'isco88=	1227	if ${wave}j`st'soc00==	1151	& j`st'semp==	1			& j`st'size==	4
replace ${wave}j`st'isco88=	1227	if ${wave}j`st'soc00==	1151	& j`st'semp==	1			& j`st'size==	5
replace ${wave}j`st'isco88=	1227	if ${wave}j`st'soc00==	1151	& j`st'semp==	1			& j`st'size==	6
replace ${wave}j`st'isco88=	1227	if ${wave}j`st'soc00==	1151	& j`st'semp==	1			& j`st'size==	7
replace ${wave}j`st'isco88=	1227	if ${wave}j`st'soc00==	1151	& j`st'semp==	1			& j`st'size==	8
replace ${wave}j`st'isco88=	1227	if ${wave}j`st'soc00==	1151	& j`st'semp==	1			& j`st'size==	9
replace ${wave}j`st'isco88=	1227	if ${wave}j`st'soc00==	1151	& j`st'semp==	1			& j`st'size==	10
replace ${wave}j`st'isco88=	-8	if ${wave}j`st'soc00==	1151	& j`st'semp==	1			& j`st'size==	11
replace ${wave}j`st'isco88=	-8	if ${wave}j`st'soc00==	1151	& j`st'semp==	1			& j`st'size==	-8
replace ${wave}j`st'isco88=	-8	if ${wave}j`st'soc00==	1151	& j`st'semp==	1			& j`st'size==	-2
replace ${wave}j`st'isco88=	-8	if ${wave}j`st'soc00==	1151	& j`st'semp==	1			& j`st'size==	-1
replace ${wave}j`st'isco88=	1317	if ${wave}j`st'soc00==	1151	& j`st'semp==	2	& jssize==	1		
replace ${wave}j`st'isco88=	1317	if ${wave}j`st'soc00==	1151	& j`st'semp==	2	& jssize==	2		
replace ${wave}j`st'isco88=	1227	if ${wave}j`st'soc00==	1151	& j`st'semp==	2	& jssize==	3		
replace ${wave}j`st'isco88=	1227	if ${wave}j`st'soc00==	1151	& j`st'semp==	2	& jssize==	4		
replace ${wave}j`st'isco88=	1227	if ${wave}j`st'soc00==	1151	& j`st'semp==	2	& jssize==	5		
replace ${wave}j`st'isco88=	1227	if ${wave}j`st'soc00==	1151	& j`st'semp==	2	& jssize==	6		
replace ${wave}j`st'isco88=	1227	if ${wave}j`st'soc00==	1151	& j`st'semp==	2	& jssize==	7		
replace ${wave}j`st'isco88=	1227	if ${wave}j`st'soc00==	1151	& j`st'semp==	2	& jssize==	8		
replace ${wave}j`st'isco88=	1227	if ${wave}j`st'soc00==	1151	& j`st'semp==	2	& jssize==	9		
replace ${wave}j`st'isco88=	1227	if ${wave}j`st'soc00==	1151	& j`st'semp==	2	& jssize==	10		
replace ${wave}j`st'isco88=	-8	if ${wave}j`st'soc00==	1151	& j`st'semp==	2	& jssize==	11		
replace ${wave}j`st'isco88=	-8	if ${wave}j`st'soc00==	1151	& j`st'semp==	2	& jssize==	-8		
replace ${wave}j`st'isco88=	-8	if ${wave}j`st'soc00==	1151	& j`st'semp==	2	& jssize==	-9		
replace ${wave}j`st'isco88=	1316	if ${wave}j`st'soc00==	1161	& j`st'semp==	1			& j`st'size==	1
replace ${wave}j`st'isco88=	1316	if ${wave}j`st'soc00==	1161	& j`st'semp==	1			& j`st'size==	2
replace ${wave}j`st'isco88=	1226	if ${wave}j`st'soc00==	1161	& j`st'semp==	1			& j`st'size==	3
replace ${wave}j`st'isco88=	1316	if ${wave}j`st'soc00==	1162	& j`st'semp==	1			& j`st'size==	4
replace ${wave}j`st'isco88=	1316	if ${wave}j`st'soc00==	1162	& j`st'semp==	1			& j`st'size==	5
replace ${wave}j`st'isco88=	1226	if ${wave}j`st'soc00==	1162	& j`st'semp==	1			& j`st'size==	6
replace ${wave}j`st'isco88=	1226	if ${wave}j`st'soc00==	1162	& j`st'semp==	1			& j`st'size==	7
replace ${wave}j`st'isco88=	1226	if ${wave}j`st'soc00==	1162	& j`st'semp==	1			& j`st'size==	8
replace ${wave}j`st'isco88=	1226	if ${wave}j`st'soc00==	1162	& j`st'semp==	1			& j`st'size==	9
replace ${wave}j`st'isco88=	1226	if ${wave}j`st'soc00==	1162	& j`st'semp==	1			& j`st'size==	10
replace ${wave}j`st'isco88=	-8	if ${wave}j`st'soc00==	1162	& j`st'semp==	1			& j`st'size==	11
replace ${wave}j`st'isco88=	-8	if ${wave}j`st'soc00==	1162	& j`st'semp==	1			& j`st'size==	-8
replace ${wave}j`st'isco88=	-8	if ${wave}j`st'soc00==	1162	& j`st'semp==	1			& j`st'size==	-2
replace ${wave}j`st'isco88=	-8	if ${wave}j`st'soc00==	1162	& j`st'semp==	1			& j`st'size==	-1
replace ${wave}j`st'isco88=	1316	if ${wave}j`st'soc00==	1161	& j`st'semp==	2	& jssize==	1		
replace ${wave}j`st'isco88=	1316	if ${wave}j`st'soc00==	1161	& j`st'semp==	2	& jssize==	2		
replace ${wave}j`st'isco88=	1226	if ${wave}j`st'soc00==	1161	& j`st'semp==	2	& jssize==	3		
replace ${wave}j`st'isco88=	1316	if ${wave}j`st'soc00==	1162	& j`st'semp==	2	& jssize==	4		
replace ${wave}j`st'isco88=	1316	if ${wave}j`st'soc00==	1162	& j`st'semp==	2	& jssize==	5		
replace ${wave}j`st'isco88=	1226	if ${wave}j`st'soc00==	1162	& j`st'semp==	2	& jssize==	6		
replace ${wave}j`st'isco88=	1226	if ${wave}j`st'soc00==	1162	& j`st'semp==	2	& jssize==	7		
replace ${wave}j`st'isco88=	1226	if ${wave}j`st'soc00==	1162	& j`st'semp==	2	& jssize==	8		
replace ${wave}j`st'isco88=	1226	if ${wave}j`st'soc00==	1162	& j`st'semp==	2	& jssize==	9		
replace ${wave}j`st'isco88=	1226	if ${wave}j`st'soc00==	1162	& j`st'semp==	2	& jssize==	10		
replace ${wave}j`st'isco88=	-8	if ${wave}j`st'soc00==	1162	& j`st'semp==	2	& jssize==	11		
replace ${wave}j`st'isco88=	-8	if ${wave}j`st'soc00==	1162	& j`st'semp==	2	& jssize==	-8		
replace ${wave}j`st'isco88=	-8	if ${wave}j`st'soc00==	1162	& j`st'semp==	2	& jssize==	-9		
replace ${wave}j`st'isco88=	1314	if ${wave}j`st'soc00==	1163	& j`st'semp==	1			& j`st'size==	1
replace ${wave}j`st'isco88=	1314	if ${wave}j`st'soc00==	1163	& j`st'semp==	1			& j`st'size==	2
replace ${wave}j`st'isco88=	1224	if ${wave}j`st'soc00==	1163	& j`st'semp==	1			& j`st'size==	3
replace ${wave}j`st'isco88=	1224	if ${wave}j`st'soc00==	1163	& j`st'semp==	1			& j`st'size==	4
replace ${wave}j`st'isco88=	1224	if ${wave}j`st'soc00==	1163	& j`st'semp==	1			& j`st'size==	5
replace ${wave}j`st'isco88=	1224	if ${wave}j`st'soc00==	1163	& j`st'semp==	1			& j`st'size==	6
replace ${wave}j`st'isco88=	1224	if ${wave}j`st'soc00==	1163	& j`st'semp==	1			& j`st'size==	7
replace ${wave}j`st'isco88=	1224	if ${wave}j`st'soc00==	1163	& j`st'semp==	1			& j`st'size==	8
replace ${wave}j`st'isco88=	1224	if ${wave}j`st'soc00==	1163	& j`st'semp==	1			& j`st'size==	9
replace ${wave}j`st'isco88=	1224	if ${wave}j`st'soc00==	1163	& j`st'semp==	1			& j`st'size==	10
replace ${wave}j`st'isco88=	-8	if ${wave}j`st'soc00==	1163	& j`st'semp==	1			& j`st'size==	11
replace ${wave}j`st'isco88=	-8	if ${wave}j`st'soc00==	1163	& j`st'semp==	1			& j`st'size==	-8
replace ${wave}j`st'isco88=	-8	if ${wave}j`st'soc00==	1163	& j`st'semp==	1			& j`st'size==	-2
replace ${wave}j`st'isco88=	-8	if ${wave}j`st'soc00==	1163	& j`st'semp==	1			& j`st'size==	-1
replace ${wave}j`st'isco88=	1314	if ${wave}j`st'soc00==	1163	& j`st'semp==	2	& jssize==	1		
replace ${wave}j`st'isco88=	1314	if ${wave}j`st'soc00==	1163	& j`st'semp==	2	& jssize==	2		
replace ${wave}j`st'isco88=	1224	if ${wave}j`st'soc00==	1163	& j`st'semp==	2	& jssize==	3		
replace ${wave}j`st'isco88=	1224	if ${wave}j`st'soc00==	1163	& j`st'semp==	2	& jssize==	4		
replace ${wave}j`st'isco88=	1224	if ${wave}j`st'soc00==	1163	& j`st'semp==	2	& jssize==	5		
replace ${wave}j`st'isco88=	1224	if ${wave}j`st'soc00==	1163	& j`st'semp==	2	& jssize==	6		
replace ${wave}j`st'isco88=	1224	if ${wave}j`st'soc00==	1163	& j`st'semp==	2	& jssize==	7		
replace ${wave}j`st'isco88=	1224	if ${wave}j`st'soc00==	1163	& j`st'semp==	2	& jssize==	8		
replace ${wave}j`st'isco88=	1224	if ${wave}j`st'soc00==	1163	& j`st'semp==	2	& jssize==	9		
replace ${wave}j`st'isco88=	1224	if ${wave}j`st'soc00==	1163	& j`st'semp==	2	& jssize==	10		
replace ${wave}j`st'isco88=	-8	if ${wave}j`st'soc00==	1163	& j`st'semp==	2	& jssize==	11		
replace ${wave}j`st'isco88=	-8	if ${wave}j`st'soc00==	1163	& j`st'semp==	2	& jssize==	-8		
replace ${wave}j`st'isco88=	-8	if ${wave}j`st'soc00==	1163	& j`st'semp==	2	& jssize==	-9		
replace ${wave}j`st'isco88=	1319	if ${wave}j`st'soc00==	1182	& j`st'semp==	1			& j`st'size==	1
replace ${wave}j`st'isco88=	1319	if ${wave}j`st'soc00==	1182	& j`st'semp==	1			& j`st'size==	2
replace ${wave}j`st'isco88=	1229	if ${wave}j`st'soc00==	1182	& j`st'semp==	1			& j`st'size==	3
replace ${wave}j`st'isco88=	1229	if ${wave}j`st'soc00==	1182	& j`st'semp==	1			& j`st'size==	4
replace ${wave}j`st'isco88=	1229	if ${wave}j`st'soc00==	1182	& j`st'semp==	1			& j`st'size==	5
replace ${wave}j`st'isco88=	1229	if ${wave}j`st'soc00==	1182	& j`st'semp==	1			& j`st'size==	6
replace ${wave}j`st'isco88=	1229	if ${wave}j`st'soc00==	1182	& j`st'semp==	1			& j`st'size==	7
replace ${wave}j`st'isco88=	1229	if ${wave}j`st'soc00==	1182	& j`st'semp==	1			& j`st'size==	8
replace ${wave}j`st'isco88=	1229	if ${wave}j`st'soc00==	1182	& j`st'semp==	1			& j`st'size==	9
replace ${wave}j`st'isco88=	1229	if ${wave}j`st'soc00==	1182	& j`st'semp==	1			& j`st'size==	10
replace ${wave}j`st'isco88=	-8	if ${wave}j`st'soc00==	1182	& j`st'semp==	1			& j`st'size==	11
replace ${wave}j`st'isco88=	-8	if ${wave}j`st'soc00==	1182	& j`st'semp==	1			& j`st'size==	-8
replace ${wave}j`st'isco88=	-8	if ${wave}j`st'soc00==	1182	& j`st'semp==	1			& j`st'size==	-2
replace ${wave}j`st'isco88=	-8	if ${wave}j`st'soc00==	1182	& j`st'semp==	1			& j`st'size==	-1
replace ${wave}j`st'isco88=	1319	if ${wave}j`st'soc00==	1182	& j`st'semp==	2	& jssize==	1		
replace ${wave}j`st'isco88=	1319	if ${wave}j`st'soc00==	1182	& j`st'semp==	2	& jssize==	2		
replace ${wave}j`st'isco88=	1229	if ${wave}j`st'soc00==	1182	& j`st'semp==	2	& jssize==	3		
replace ${wave}j`st'isco88=	1229	if ${wave}j`st'soc00==	1182	& j`st'semp==	2	& jssize==	4		
replace ${wave}j`st'isco88=	1229	if ${wave}j`st'soc00==	1182	& j`st'semp==	2	& jssize==	5		
replace ${wave}j`st'isco88=	1229	if ${wave}j`st'soc00==	1182	& j`st'semp==	2	& jssize==	6		
replace ${wave}j`st'isco88=	1229	if ${wave}j`st'soc00==	1182	& j`st'semp==	2	& jssize==	7		
replace ${wave}j`st'isco88=	1229	if ${wave}j`st'soc00==	1182	& j`st'semp==	2	& jssize==	8		
replace ${wave}j`st'isco88=	1229	if ${wave}j`st'soc00==	1182	& j`st'semp==	2	& jssize==	9		
replace ${wave}j`st'isco88=	1229	if ${wave}j`st'soc00==	1182	& j`st'semp==	2	& jssize==	10		
replace ${wave}j`st'isco88=	-8	if ${wave}j`st'soc00==	1182	& j`st'semp==	2	& jssize==	11		
replace ${wave}j`st'isco88=	-8	if ${wave}j`st'soc00==	1182	& j`st'semp==	2	& jssize==	-8		
replace ${wave}j`st'isco88=	-8	if ${wave}j`st'soc00==	1182	& j`st'semp==	2	& jssize==	-9		
replace ${wave}j`st'isco88=	1319	if ${wave}j`st'soc00==	1183	& j`st'semp==	1			& j`st'size==	1
replace ${wave}j`st'isco88=	1319	if ${wave}j`st'soc00==	1183	& j`st'semp==	1			& j`st'size==	2
replace ${wave}j`st'isco88=	1229	if ${wave}j`st'soc00==	1183	& j`st'semp==	1			& j`st'size==	3
replace ${wave}j`st'isco88=	1229	if ${wave}j`st'soc00==	1183	& j`st'semp==	1			& j`st'size==	4
replace ${wave}j`st'isco88=	1229	if ${wave}j`st'soc00==	1183	& j`st'semp==	1			& j`st'size==	5
replace ${wave}j`st'isco88=	1229	if ${wave}j`st'soc00==	1183	& j`st'semp==	1			& j`st'size==	6
replace ${wave}j`st'isco88=	1229	if ${wave}j`st'soc00==	1183	& j`st'semp==	1			& j`st'size==	7
replace ${wave}j`st'isco88=	1229	if ${wave}j`st'soc00==	1183	& j`st'semp==	1			& j`st'size==	8
replace ${wave}j`st'isco88=	1229	if ${wave}j`st'soc00==	1183	& j`st'semp==	1			& j`st'size==	9
replace ${wave}j`st'isco88=	1229	if ${wave}j`st'soc00==	1183	& j`st'semp==	1			& j`st'size==	10
replace ${wave}j`st'isco88=	-8	if ${wave}j`st'soc00==	1183	& j`st'semp==	1			& j`st'size==	11
replace ${wave}j`st'isco88=	-8	if ${wave}j`st'soc00==	1183	& j`st'semp==	1			& j`st'size==	-8
replace ${wave}j`st'isco88=	-8	if ${wave}j`st'soc00==	1183	& j`st'semp==	1			& j`st'size==	-2
replace ${wave}j`st'isco88=	-8	if ${wave}j`st'soc00==	1183	& j`st'semp==	1			& j`st'size==	-1
replace ${wave}j`st'isco88=	1319	if ${wave}j`st'soc00==	1183	& j`st'semp==	2	& jssize==	1		
replace ${wave}j`st'isco88=	1319	if ${wave}j`st'soc00==	1183	& j`st'semp==	2	& jssize==	2		
replace ${wave}j`st'isco88=	1229	if ${wave}j`st'soc00==	1183	& j`st'semp==	2	& jssize==	3		
replace ${wave}j`st'isco88=	1229	if ${wave}j`st'soc00==	1183	& j`st'semp==	2	& jssize==	4		
replace ${wave}j`st'isco88=	1229	if ${wave}j`st'soc00==	1183	& j`st'semp==	2	& jssize==	5		
replace ${wave}j`st'isco88=	1229	if ${wave}j`st'soc00==	1183	& j`st'semp==	2	& jssize==	6		
replace ${wave}j`st'isco88=	1229	if ${wave}j`st'soc00==	1183	& j`st'semp==	2	& jssize==	7		
replace ${wave}j`st'isco88=	1229	if ${wave}j`st'soc00==	1183	& j`st'semp==	2	& jssize==	8		
replace ${wave}j`st'isco88=	1229	if ${wave}j`st'soc00==	1183	& j`st'semp==	2	& jssize==	9		
replace ${wave}j`st'isco88=	1229	if ${wave}j`st'soc00==	1183	& j`st'semp==	2	& jssize==	10		
replace ${wave}j`st'isco88=	-8	if ${wave}j`st'soc00==	1183	& j`st'semp==	2	& jssize==	11		
replace ${wave}j`st'isco88=	-8	if ${wave}j`st'soc00==	1183	& j`st'semp==	2	& jssize==	-8		
replace ${wave}j`st'isco88=	-8	if ${wave}j`st'soc00==	1183	& j`st'semp==	2	& jssize==	-9		
replace ${wave}j`st'isco88=	1318	if ${wave}j`st'soc00==	1185	& j`st'semp==	1			& j`st'size==	1
replace ${wave}j`st'isco88=	1318	if ${wave}j`st'soc00==	1185	& j`st'semp==	1			& j`st'size==	2
replace ${wave}j`st'isco88=	1228	if ${wave}j`st'soc00==	1185	& j`st'semp==	1			& j`st'size==	3
replace ${wave}j`st'isco88=	1228	if ${wave}j`st'soc00==	1185	& j`st'semp==	1			& j`st'size==	4
replace ${wave}j`st'isco88=	1228	if ${wave}j`st'soc00==	1185	& j`st'semp==	1			& j`st'size==	5
replace ${wave}j`st'isco88=	1228	if ${wave}j`st'soc00==	1185	& j`st'semp==	1			& j`st'size==	6
replace ${wave}j`st'isco88=	1228	if ${wave}j`st'soc00==	1185	& j`st'semp==	1			& j`st'size==	7
replace ${wave}j`st'isco88=	1228	if ${wave}j`st'soc00==	1185	& j`st'semp==	1			& j`st'size==	8
replace ${wave}j`st'isco88=	1228	if ${wave}j`st'soc00==	1185	& j`st'semp==	1			& j`st'size==	9
replace ${wave}j`st'isco88=	1228	if ${wave}j`st'soc00==	1185	& j`st'semp==	1			& j`st'size==	10
replace ${wave}j`st'isco88=	-8	if ${wave}j`st'soc00==	1185	& j`st'semp==	1			& j`st'size==	11
replace ${wave}j`st'isco88=	-8	if ${wave}j`st'soc00==	1185	& j`st'semp==	1			& j`st'size==	-8
replace ${wave}j`st'isco88=	-8	if ${wave}j`st'soc00==	1185	& j`st'semp==	1			& j`st'size==	-2
replace ${wave}j`st'isco88=	-8	if ${wave}j`st'soc00==	1185	& j`st'semp==	1			& j`st'size==	-1
replace ${wave}j`st'isco88=	1318	if ${wave}j`st'soc00==	1185	& j`st'semp==	2	& jssize==	1		
replace ${wave}j`st'isco88=	1318	if ${wave}j`st'soc00==	1185	& j`st'semp==	2	& jssize==	2		
replace ${wave}j`st'isco88=	1228	if ${wave}j`st'soc00==	1185	& j`st'semp==	2	& jssize==	3		
replace ${wave}j`st'isco88=	1228	if ${wave}j`st'soc00==	1185	& j`st'semp==	2	& jssize==	4		
replace ${wave}j`st'isco88=	1228	if ${wave}j`st'soc00==	1185	& j`st'semp==	2	& jssize==	5		
replace ${wave}j`st'isco88=	1228	if ${wave}j`st'soc00==	1185	& j`st'semp==	2	& jssize==	6		
replace ${wave}j`st'isco88=	1228	if ${wave}j`st'soc00==	1185	& j`st'semp==	2	& jssize==	7		
replace ${wave}j`st'isco88=	1228	if ${wave}j`st'soc00==	1185	& j`st'semp==	2	& jssize==	8		
replace ${wave}j`st'isco88=	1228	if ${wave}j`st'soc00==	1185	& j`st'semp==	2	& jssize==	9		
replace ${wave}j`st'isco88=	1228	if ${wave}j`st'soc00==	1185	& j`st'semp==	2	& jssize==	10		
replace ${wave}j`st'isco88=	-8	if ${wave}j`st'soc00==	1185	& j`st'semp==	2	& jssize==	11		
replace ${wave}j`st'isco88=	-8	if ${wave}j`st'soc00==	1185	& j`st'semp==	2	& jssize==	-8		
replace ${wave}j`st'isco88=	-8	if ${wave}j`st'soc00==	1185	& j`st'semp==	2	& jssize==	-9		
replace ${wave}j`st'isco88=	1311	if ${wave}j`st'soc00==	1211	& j`st'semp==	1			& j`st'size==	1
replace ${wave}j`st'isco88=	1311	if ${wave}j`st'soc00==	1211	& j`st'semp==	1			& j`st'size==	2
replace ${wave}j`st'isco88=	1221	if ${wave}j`st'soc00==	1211	& j`st'semp==	1			& j`st'size==	3
replace ${wave}j`st'isco88=	1221	if ${wave}j`st'soc00==	1211	& j`st'semp==	1			& j`st'size==	4
replace ${wave}j`st'isco88=	1221	if ${wave}j`st'soc00==	1211	& j`st'semp==	1			& j`st'size==	5
replace ${wave}j`st'isco88=	1221	if ${wave}j`st'soc00==	1211	& j`st'semp==	1			& j`st'size==	6
replace ${wave}j`st'isco88=	1221	if ${wave}j`st'soc00==	1211	& j`st'semp==	1			& j`st'size==	7
replace ${wave}j`st'isco88=	1221	if ${wave}j`st'soc00==	1211	& j`st'semp==	1			& j`st'size==	8
replace ${wave}j`st'isco88=	1221	if ${wave}j`st'soc00==	1211	& j`st'semp==	1			& j`st'size==	9
replace ${wave}j`st'isco88=	1221	if ${wave}j`st'soc00==	1211	& j`st'semp==	1			& j`st'size==	10
replace ${wave}j`st'isco88=	-8	if ${wave}j`st'soc00==	1211	& j`st'semp==	1			& j`st'size==	11
replace ${wave}j`st'isco88=	-8	if ${wave}j`st'soc00==	1211	& j`st'semp==	1			& j`st'size==	-8
replace ${wave}j`st'isco88=	-8	if ${wave}j`st'soc00==	1211	& j`st'semp==	1			& j`st'size==	-2
replace ${wave}j`st'isco88=	-8	if ${wave}j`st'soc00==	1211	& j`st'semp==	1			& j`st'size==	-1
replace ${wave}j`st'isco88=	1311	if ${wave}j`st'soc00==	1211	& j`st'semp==	2	& jssize==	1		
replace ${wave}j`st'isco88=	1311	if ${wave}j`st'soc00==	1211	& j`st'semp==	2	& jssize==	2		
replace ${wave}j`st'isco88=	1221	if ${wave}j`st'soc00==	1211	& j`st'semp==	2	& jssize==	3		
replace ${wave}j`st'isco88=	1221	if ${wave}j`st'soc00==	1211	& j`st'semp==	2	& jssize==	4		
replace ${wave}j`st'isco88=	1221	if ${wave}j`st'soc00==	1211	& j`st'semp==	2	& jssize==	5		
replace ${wave}j`st'isco88=	1221	if ${wave}j`st'soc00==	1211	& j`st'semp==	2	& jssize==	6		
replace ${wave}j`st'isco88=	1221	if ${wave}j`st'soc00==	1211	& j`st'semp==	2	& jssize==	7		
replace ${wave}j`st'isco88=	1221	if ${wave}j`st'soc00==	1211	& j`st'semp==	2	& jssize==	8		
replace ${wave}j`st'isco88=	1221	if ${wave}j`st'soc00==	1211	& j`st'semp==	2	& jssize==	9		
replace ${wave}j`st'isco88=	1221	if ${wave}j`st'soc00==	1211	& j`st'semp==	2	& jssize==	10		
replace ${wave}j`st'isco88=	-8	if ${wave}j`st'soc00==	1211	& j`st'semp==	2	& jssize==	11		
replace ${wave}j`st'isco88=	-8	if ${wave}j`st'soc00==	1211	& j`st'semp==	2	& jssize==	-8		
replace ${wave}j`st'isco88=	-8	if ${wave}j`st'soc00==	1211	& j`st'semp==	2	& jssize==	-9		
replace ${wave}j`st'isco88=	1311	if ${wave}j`st'soc00==	1212	& j`st'semp==	1			& j`st'size==	1
replace ${wave}j`st'isco88=	1311	if ${wave}j`st'soc00==	1212	& j`st'semp==	1			& j`st'size==	2
replace ${wave}j`st'isco88=	1221	if ${wave}j`st'soc00==	1212	& j`st'semp==	1			& j`st'size==	3
replace ${wave}j`st'isco88=	1221	if ${wave}j`st'soc00==	1212	& j`st'semp==	1			& j`st'size==	4
replace ${wave}j`st'isco88=	1221	if ${wave}j`st'soc00==	1212	& j`st'semp==	1			& j`st'size==	5
replace ${wave}j`st'isco88=	1221	if ${wave}j`st'soc00==	1212	& j`st'semp==	1			& j`st'size==	6
replace ${wave}j`st'isco88=	1221	if ${wave}j`st'soc00==	1212	& j`st'semp==	1			& j`st'size==	7
replace ${wave}j`st'isco88=	1221	if ${wave}j`st'soc00==	1212	& j`st'semp==	1			& j`st'size==	8
replace ${wave}j`st'isco88=	1221	if ${wave}j`st'soc00==	1212	& j`st'semp==	1			& j`st'size==	9
replace ${wave}j`st'isco88=	1221	if ${wave}j`st'soc00==	1212	& j`st'semp==	1			& j`st'size==	10
replace ${wave}j`st'isco88=	-8	if ${wave}j`st'soc00==	1212	& j`st'semp==	1			& j`st'size==	11
replace ${wave}j`st'isco88=	-8	if ${wave}j`st'soc00==	1212	& j`st'semp==	1			& j`st'size==	-8
replace ${wave}j`st'isco88=	-8	if ${wave}j`st'soc00==	1212	& j`st'semp==	1			& j`st'size==	-2
replace ${wave}j`st'isco88=	-8	if ${wave}j`st'soc00==	1212	& j`st'semp==	1			& j`st'size==	-1
replace ${wave}j`st'isco88=	1311	if ${wave}j`st'soc00==	1212	& j`st'semp==	2	& jssize==	1		
replace ${wave}j`st'isco88=	1311	if ${wave}j`st'soc00==	1212	& j`st'semp==	2	& jssize==	2		
replace ${wave}j`st'isco88=	1221	if ${wave}j`st'soc00==	1212	& j`st'semp==	2	& jssize==	3		
replace ${wave}j`st'isco88=	1221	if ${wave}j`st'soc00==	1212	& j`st'semp==	2	& jssize==	4		
replace ${wave}j`st'isco88=	1221	if ${wave}j`st'soc00==	1212	& j`st'semp==	2	& jssize==	5		
replace ${wave}j`st'isco88=	1221	if ${wave}j`st'soc00==	1212	& j`st'semp==	2	& jssize==	6		
replace ${wave}j`st'isco88=	1221	if ${wave}j`st'soc00==	1212	& j`st'semp==	2	& jssize==	7		
replace ${wave}j`st'isco88=	1221	if ${wave}j`st'soc00==	1212	& j`st'semp==	2	& jssize==	8		
replace ${wave}j`st'isco88=	1221	if ${wave}j`st'soc00==	1212	& j`st'semp==	2	& jssize==	9		
replace ${wave}j`st'isco88=	1221	if ${wave}j`st'soc00==	1212	& j`st'semp==	2	& jssize==	10		
replace ${wave}j`st'isco88=	-8	if ${wave}j`st'soc00==	1212	& j`st'semp==	2	& jssize==	11		
replace ${wave}j`st'isco88=	-8	if ${wave}j`st'soc00==	1212	& j`st'semp==	2	& jssize==	-8		
replace ${wave}j`st'isco88=	-8	if ${wave}j`st'soc00==	1212	& j`st'semp==	2	& jssize==	-9		
replace ${wave}j`st'isco88=	1311	if ${wave}j`st'soc00==	1219	& j`st'semp==	1			& j`st'size==	1
replace ${wave}j`st'isco88=	1311	if ${wave}j`st'soc00==	1219	& j`st'semp==	1			& j`st'size==	2
replace ${wave}j`st'isco88=	1221	if ${wave}j`st'soc00==	1219	& j`st'semp==	1			& j`st'size==	3
replace ${wave}j`st'isco88=	1221	if ${wave}j`st'soc00==	1219	& j`st'semp==	1			& j`st'size==	4
replace ${wave}j`st'isco88=	1221	if ${wave}j`st'soc00==	1219	& j`st'semp==	1			& j`st'size==	5
replace ${wave}j`st'isco88=	1221	if ${wave}j`st'soc00==	1219	& j`st'semp==	1			& j`st'size==	6
replace ${wave}j`st'isco88=	1221	if ${wave}j`st'soc00==	1219	& j`st'semp==	1			& j`st'size==	7
replace ${wave}j`st'isco88=	1221	if ${wave}j`st'soc00==	1219	& j`st'semp==	1			& j`st'size==	8
replace ${wave}j`st'isco88=	1221	if ${wave}j`st'soc00==	1219	& j`st'semp==	1			& j`st'size==	9
replace ${wave}j`st'isco88=	1221	if ${wave}j`st'soc00==	1219	& j`st'semp==	1			& j`st'size==	10
replace ${wave}j`st'isco88=	-8	if ${wave}j`st'soc00==	1219	& j`st'semp==	1			& j`st'size==	11
replace ${wave}j`st'isco88=	-8	if ${wave}j`st'soc00==	1219	& j`st'semp==	1			& j`st'size==	-8
replace ${wave}j`st'isco88=	-8	if ${wave}j`st'soc00==	1219	& j`st'semp==	1			& j`st'size==	-2
replace ${wave}j`st'isco88=	-8	if ${wave}j`st'soc00==	1219	& j`st'semp==	1			& j`st'size==	-1
replace ${wave}j`st'isco88=	1311	if ${wave}j`st'soc00==	1219	& j`st'semp==	2	& jssize==	1		
replace ${wave}j`st'isco88=	1311	if ${wave}j`st'soc00==	1219	& j`st'semp==	2	& jssize==	2		
replace ${wave}j`st'isco88=	1221	if ${wave}j`st'soc00==	1219	& j`st'semp==	2	& jssize==	3		
replace ${wave}j`st'isco88=	1221	if ${wave}j`st'soc00==	1219	& j`st'semp==	2	& jssize==	4		
replace ${wave}j`st'isco88=	1221	if ${wave}j`st'soc00==	1219	& j`st'semp==	2	& jssize==	5		
replace ${wave}j`st'isco88=	1221	if ${wave}j`st'soc00==	1219	& j`st'semp==	2	& jssize==	6		
replace ${wave}j`st'isco88=	1221	if ${wave}j`st'soc00==	1219	& j`st'semp==	2	& jssize==	7		
replace ${wave}j`st'isco88=	1221	if ${wave}j`st'soc00==	1219	& j`st'semp==	2	& jssize==	8		
replace ${wave}j`st'isco88=	1221	if ${wave}j`st'soc00==	1219	& j`st'semp==	2	& jssize==	9		
replace ${wave}j`st'isco88=	1221	if ${wave}j`st'soc00==	1219	& j`st'semp==	2	& jssize==	10		
replace ${wave}j`st'isco88=	-8	if ${wave}j`st'soc00==	1219	& j`st'semp==	2	& jssize==	11		
replace ${wave}j`st'isco88=	-8	if ${wave}j`st'soc00==	1219	& j`st'semp==	2	& jssize==	-8		
replace ${wave}j`st'isco88=	-8	if ${wave}j`st'soc00==	1219	& j`st'semp==	2	& jssize==	-9		
replace ${wave}j`st'isco88=	1315	if ${wave}j`st'soc00==	1221	& j`st'semp==	1			& j`st'size==	1
replace ${wave}j`st'isco88=	1315	if ${wave}j`st'soc00==	1221	& j`st'semp==	1			& j`st'size==	2
replace ${wave}j`st'isco88=	1225	if ${wave}j`st'soc00==	1221	& j`st'semp==	1			& j`st'size==	3
replace ${wave}j`st'isco88=	1225	if ${wave}j`st'soc00==	1221	& j`st'semp==	1			& j`st'size==	4
replace ${wave}j`st'isco88=	1225	if ${wave}j`st'soc00==	1221	& j`st'semp==	1			& j`st'size==	5
replace ${wave}j`st'isco88=	1225	if ${wave}j`st'soc00==	1221	& j`st'semp==	1			& j`st'size==	6
replace ${wave}j`st'isco88=	1225	if ${wave}j`st'soc00==	1221	& j`st'semp==	1			& j`st'size==	7
replace ${wave}j`st'isco88=	1225	if ${wave}j`st'soc00==	1221	& j`st'semp==	1			& j`st'size==	8
replace ${wave}j`st'isco88=	1225	if ${wave}j`st'soc00==	1221	& j`st'semp==	1			& j`st'size==	9
replace ${wave}j`st'isco88=	1225	if ${wave}j`st'soc00==	1221	& j`st'semp==	1			& j`st'size==	10
replace ${wave}j`st'isco88=	-8	if ${wave}j`st'soc00==	1221	& j`st'semp==	1			& j`st'size==	11
replace ${wave}j`st'isco88=	-8	if ${wave}j`st'soc00==	1221	& j`st'semp==	1			& j`st'size==	-8
replace ${wave}j`st'isco88=	-8	if ${wave}j`st'soc00==	1221	& j`st'semp==	1			& j`st'size==	-2
replace ${wave}j`st'isco88=	-8	if ${wave}j`st'soc00==	1221	& j`st'semp==	1			& j`st'size==	-1
replace ${wave}j`st'isco88=	1315	if ${wave}j`st'soc00==	1221	& j`st'semp==	2	& jssize==	1		
replace ${wave}j`st'isco88=	1315	if ${wave}j`st'soc00==	1221	& j`st'semp==	2	& jssize==	2		
replace ${wave}j`st'isco88=	1225	if ${wave}j`st'soc00==	1221	& j`st'semp==	2	& jssize==	3		
replace ${wave}j`st'isco88=	1225	if ${wave}j`st'soc00==	1221	& j`st'semp==	2	& jssize==	4		
replace ${wave}j`st'isco88=	1225	if ${wave}j`st'soc00==	1221	& j`st'semp==	2	& jssize==	5		
replace ${wave}j`st'isco88=	1225	if ${wave}j`st'soc00==	1221	& j`st'semp==	2	& jssize==	6		
replace ${wave}j`st'isco88=	1225	if ${wave}j`st'soc00==	1221	& j`st'semp==	2	& jssize==	7		
replace ${wave}j`st'isco88=	1225	if ${wave}j`st'soc00==	1221	& j`st'semp==	2	& jssize==	8		
replace ${wave}j`st'isco88=	1225	if ${wave}j`st'soc00==	1221	& j`st'semp==	2	& jssize==	9		
replace ${wave}j`st'isco88=	1225	if ${wave}j`st'soc00==	1221	& j`st'semp==	2	& jssize==	10		
replace ${wave}j`st'isco88=	-8	if ${wave}j`st'soc00==	1221	& j`st'semp==	2	& jssize==	11		
replace ${wave}j`st'isco88=	-8	if ${wave}j`st'soc00==	1221	& j`st'semp==	2	& jssize==	-8		
replace ${wave}j`st'isco88=	-8	if ${wave}j`st'soc00==	1221	& j`st'semp==	2	& jssize==	-9		
replace ${wave}j`st'isco88=	1317	if ${wave}j`st'soc00==	1222	& j`st'semp==	1			& j`st'size==	1
replace ${wave}j`st'isco88=	1317	if ${wave}j`st'soc00==	1222	& j`st'semp==	1			& j`st'size==	2
replace ${wave}j`st'isco88=	1227	if ${wave}j`st'soc00==	1222	& j`st'semp==	1			& j`st'size==	3
replace ${wave}j`st'isco88=	1227	if ${wave}j`st'soc00==	1222	& j`st'semp==	1			& j`st'size==	4
replace ${wave}j`st'isco88=	1227	if ${wave}j`st'soc00==	1222	& j`st'semp==	1			& j`st'size==	5
replace ${wave}j`st'isco88=	1227	if ${wave}j`st'soc00==	1222	& j`st'semp==	1			& j`st'size==	6
replace ${wave}j`st'isco88=	1227	if ${wave}j`st'soc00==	1222	& j`st'semp==	1			& j`st'size==	7
replace ${wave}j`st'isco88=	1227	if ${wave}j`st'soc00==	1222	& j`st'semp==	1			& j`st'size==	8
replace ${wave}j`st'isco88=	1227	if ${wave}j`st'soc00==	1222	& j`st'semp==	1			& j`st'size==	9
replace ${wave}j`st'isco88=	1227	if ${wave}j`st'soc00==	1222	& j`st'semp==	1			& j`st'size==	10
replace ${wave}j`st'isco88=	-8	if ${wave}j`st'soc00==	1222	& j`st'semp==	1			& j`st'size==	11
replace ${wave}j`st'isco88=	-8	if ${wave}j`st'soc00==	1222	& j`st'semp==	1			& j`st'size==	-8
replace ${wave}j`st'isco88=	-8	if ${wave}j`st'soc00==	1222	& j`st'semp==	1			& j`st'size==	-2
replace ${wave}j`st'isco88=	-8	if ${wave}j`st'soc00==	1222	& j`st'semp==	1			& j`st'size==	-1
replace ${wave}j`st'isco88=	1317	if ${wave}j`st'soc00==	1222	& j`st'semp==	2	& jssize==	1		
replace ${wave}j`st'isco88=	1317	if ${wave}j`st'soc00==	1222	& j`st'semp==	2	& jssize==	2		
replace ${wave}j`st'isco88=	1227	if ${wave}j`st'soc00==	1222	& j`st'semp==	2	& jssize==	3		
replace ${wave}j`st'isco88=	1227	if ${wave}j`st'soc00==	1222	& j`st'semp==	2	& jssize==	4		
replace ${wave}j`st'isco88=	1227	if ${wave}j`st'soc00==	1222	& j`st'semp==	2	& jssize==	5		
replace ${wave}j`st'isco88=	1227	if ${wave}j`st'soc00==	1222	& j`st'semp==	2	& jssize==	6		
replace ${wave}j`st'isco88=	1227	if ${wave}j`st'soc00==	1222	& j`st'semp==	2	& jssize==	7		
replace ${wave}j`st'isco88=	1227	if ${wave}j`st'soc00==	1222	& j`st'semp==	2	& jssize==	8		
replace ${wave}j`st'isco88=	1227	if ${wave}j`st'soc00==	1222	& j`st'semp==	2	& jssize==	9		
replace ${wave}j`st'isco88=	1227	if ${wave}j`st'soc00==	1222	& j`st'semp==	2	& jssize==	10		
replace ${wave}j`st'isco88=	-8	if ${wave}j`st'soc00==	1222	& j`st'semp==	2	& jssize==	11		
replace ${wave}j`st'isco88=	-8	if ${wave}j`st'soc00==	1222	& j`st'semp==	2	& jssize==	-8		
replace ${wave}j`st'isco88=	-8	if ${wave}j`st'soc00==	1222	& j`st'semp==	2	& jssize==	-9		
replace ${wave}j`st'isco88=	1315	if ${wave}j`st'soc00==	1223	& j`st'semp==	1			& j`st'size==	1
replace ${wave}j`st'isco88=	1315	if ${wave}j`st'soc00==	1223	& j`st'semp==	1			& j`st'size==	2
replace ${wave}j`st'isco88=	1225	if ${wave}j`st'soc00==	1223	& j`st'semp==	1			& j`st'size==	3
replace ${wave}j`st'isco88=	1225	if ${wave}j`st'soc00==	1223	& j`st'semp==	1			& j`st'size==	4
replace ${wave}j`st'isco88=	1225	if ${wave}j`st'soc00==	1223	& j`st'semp==	1			& j`st'size==	5
replace ${wave}j`st'isco88=	1225	if ${wave}j`st'soc00==	1223	& j`st'semp==	1			& j`st'size==	6
replace ${wave}j`st'isco88=	1225	if ${wave}j`st'soc00==	1223	& j`st'semp==	1			& j`st'size==	7
replace ${wave}j`st'isco88=	1225	if ${wave}j`st'soc00==	1223	& j`st'semp==	1			& j`st'size==	8
replace ${wave}j`st'isco88=	1225	if ${wave}j`st'soc00==	1223	& j`st'semp==	1			& j`st'size==	9
replace ${wave}j`st'isco88=	1225	if ${wave}j`st'soc00==	1223	& j`st'semp==	1			& j`st'size==	10
replace ${wave}j`st'isco88=	-8	if ${wave}j`st'soc00==	1223	& j`st'semp==	1			& j`st'size==	11
replace ${wave}j`st'isco88=	-8	if ${wave}j`st'soc00==	1223	& j`st'semp==	1			& j`st'size==	-8
replace ${wave}j`st'isco88=	-8	if ${wave}j`st'soc00==	1223	& j`st'semp==	1			& j`st'size==	-2
replace ${wave}j`st'isco88=	-8	if ${wave}j`st'soc00==	1223	& j`st'semp==	1			& j`st'size==	-1
replace ${wave}j`st'isco88=	1315	if ${wave}j`st'soc00==	1223	& j`st'semp==	2	& jssize==	1		
replace ${wave}j`st'isco88=	1315	if ${wave}j`st'soc00==	1223	& j`st'semp==	2	& jssize==	2		
replace ${wave}j`st'isco88=	1225	if ${wave}j`st'soc00==	1223	& j`st'semp==	2	& jssize==	3		
replace ${wave}j`st'isco88=	1225	if ${wave}j`st'soc00==	1223	& j`st'semp==	2	& jssize==	4		
replace ${wave}j`st'isco88=	1225	if ${wave}j`st'soc00==	1223	& j`st'semp==	2	& jssize==	5		
replace ${wave}j`st'isco88=	1225	if ${wave}j`st'soc00==	1223	& j`st'semp==	2	& jssize==	6		
replace ${wave}j`st'isco88=	1225	if ${wave}j`st'soc00==	1223	& j`st'semp==	2	& jssize==	7		
replace ${wave}j`st'isco88=	1225	if ${wave}j`st'soc00==	1223	& j`st'semp==	2	& jssize==	8		
replace ${wave}j`st'isco88=	1225	if ${wave}j`st'soc00==	1223	& j`st'semp==	2	& jssize==	9		
replace ${wave}j`st'isco88=	1225	if ${wave}j`st'soc00==	1223	& j`st'semp==	2	& jssize==	10		
replace ${wave}j`st'isco88=	-8	if ${wave}j`st'soc00==	1223	& j`st'semp==	2	& jssize==	11		
replace ${wave}j`st'isco88=	-8	if ${wave}j`st'soc00==	1223	& j`st'semp==	2	& jssize==	-8		
replace ${wave}j`st'isco88=	-8	if ${wave}j`st'soc00==	1223	& j`st'semp==	2	& jssize==	-9		
replace ${wave}j`st'isco88=	1315	if ${wave}j`st'soc00==	1224	& j`st'semp==	1			& j`st'size==	1
replace ${wave}j`st'isco88=	1315	if ${wave}j`st'soc00==	1224	& j`st'semp==	1			& j`st'size==	2
replace ${wave}j`st'isco88=	1225	if ${wave}j`st'soc00==	1224	& j`st'semp==	1			& j`st'size==	3
replace ${wave}j`st'isco88=	1225	if ${wave}j`st'soc00==	1224	& j`st'semp==	1			& j`st'size==	4
replace ${wave}j`st'isco88=	1225	if ${wave}j`st'soc00==	1224	& j`st'semp==	1			& j`st'size==	5
replace ${wave}j`st'isco88=	1225	if ${wave}j`st'soc00==	1224	& j`st'semp==	1			& j`st'size==	6
replace ${wave}j`st'isco88=	1225	if ${wave}j`st'soc00==	1224	& j`st'semp==	1			& j`st'size==	7
replace ${wave}j`st'isco88=	1225	if ${wave}j`st'soc00==	1224	& j`st'semp==	1			& j`st'size==	8
replace ${wave}j`st'isco88=	1225	if ${wave}j`st'soc00==	1224	& j`st'semp==	1			& j`st'size==	9
replace ${wave}j`st'isco88=	1225	if ${wave}j`st'soc00==	1224	& j`st'semp==	1			& j`st'size==	10
replace ${wave}j`st'isco88=	-8	if ${wave}j`st'soc00==	1224	& j`st'semp==	1			& j`st'size==	11
replace ${wave}j`st'isco88=	-8	if ${wave}j`st'soc00==	1224	& j`st'semp==	1			& j`st'size==	-8
replace ${wave}j`st'isco88=	-8	if ${wave}j`st'soc00==	1224	& j`st'semp==	1			& j`st'size==	-2
replace ${wave}j`st'isco88=	-8	if ${wave}j`st'soc00==	1224	& j`st'semp==	1			& j`st'size==	-1
replace ${wave}j`st'isco88=	1315	if ${wave}j`st'soc00==	1224	& j`st'semp==	2	& jssize==	1		
replace ${wave}j`st'isco88=	1315	if ${wave}j`st'soc00==	1224	& j`st'semp==	2	& jssize==	2		
replace ${wave}j`st'isco88=	1225	if ${wave}j`st'soc00==	1224	& j`st'semp==	2	& jssize==	3		
replace ${wave}j`st'isco88=	1225	if ${wave}j`st'soc00==	1224	& j`st'semp==	2	& jssize==	4		
replace ${wave}j`st'isco88=	1225	if ${wave}j`st'soc00==	1224	& j`st'semp==	2	& jssize==	5		
replace ${wave}j`st'isco88=	1225	if ${wave}j`st'soc00==	1224	& j`st'semp==	2	& jssize==	6		
replace ${wave}j`st'isco88=	1225	if ${wave}j`st'soc00==	1224	& j`st'semp==	2	& jssize==	7		
replace ${wave}j`st'isco88=	1225	if ${wave}j`st'soc00==	1224	& j`st'semp==	2	& jssize==	8		
replace ${wave}j`st'isco88=	1225	if ${wave}j`st'soc00==	1224	& j`st'semp==	2	& jssize==	9		
replace ${wave}j`st'isco88=	1225	if ${wave}j`st'soc00==	1224	& j`st'semp==	2	& jssize==	10		
replace ${wave}j`st'isco88=	-8	if ${wave}j`st'soc00==	1224	& j`st'semp==	2	& jssize==	11		
replace ${wave}j`st'isco88=	-8	if ${wave}j`st'soc00==	1224	& j`st'semp==	2	& jssize==	-8		
replace ${wave}j`st'isco88=	-8	if ${wave}j`st'soc00==	1224	& j`st'semp==	2	& jssize==	-9		
replace ${wave}j`st'isco88=	1319	if ${wave}j`st'soc00==	1225	& j`st'semp==	1			& j`st'size==	1
replace ${wave}j`st'isco88=	1319	if ${wave}j`st'soc00==	1225	& j`st'semp==	1			& j`st'size==	2
replace ${wave}j`st'isco88=	1229	if ${wave}j`st'soc00==	1225	& j`st'semp==	1			& j`st'size==	3
replace ${wave}j`st'isco88=	1229	if ${wave}j`st'soc00==	1225	& j`st'semp==	1			& j`st'size==	4
replace ${wave}j`st'isco88=	1229	if ${wave}j`st'soc00==	1225	& j`st'semp==	1			& j`st'size==	5
replace ${wave}j`st'isco88=	1229	if ${wave}j`st'soc00==	1225	& j`st'semp==	1			& j`st'size==	6
replace ${wave}j`st'isco88=	1229	if ${wave}j`st'soc00==	1225	& j`st'semp==	1			& j`st'size==	7
replace ${wave}j`st'isco88=	1229	if ${wave}j`st'soc00==	1225	& j`st'semp==	1			& j`st'size==	8
replace ${wave}j`st'isco88=	1229	if ${wave}j`st'soc00==	1225	& j`st'semp==	1			& j`st'size==	9
replace ${wave}j`st'isco88=	1229	if ${wave}j`st'soc00==	1225	& j`st'semp==	1			& j`st'size==	10
replace ${wave}j`st'isco88=	-8	if ${wave}j`st'soc00==	1225	& j`st'semp==	1			& j`st'size==	11
replace ${wave}j`st'isco88=	-8	if ${wave}j`st'soc00==	1225	& j`st'semp==	1			& j`st'size==	-8
replace ${wave}j`st'isco88=	-8	if ${wave}j`st'soc00==	1225	& j`st'semp==	1			& j`st'size==	-2
replace ${wave}j`st'isco88=	-8	if ${wave}j`st'soc00==	1225	& j`st'semp==	1			& j`st'size==	-1
replace ${wave}j`st'isco88=	1319	if ${wave}j`st'soc00==	1225	& j`st'semp==	2			& j`st'size==	1
replace ${wave}j`st'isco88=	1319	if ${wave}j`st'soc00==	1225	& j`st'semp==	2			& j`st'size==	2
replace ${wave}j`st'isco88=	1229	if ${wave}j`st'soc00==	1225	& j`st'semp==	2			& j`st'size==	3
replace ${wave}j`st'isco88=	1229	if ${wave}j`st'soc00==	1225	& j`st'semp==	2			& j`st'size==	4
replace ${wave}j`st'isco88=	1229	if ${wave}j`st'soc00==	1225	& j`st'semp==	2			& j`st'size==	5
replace ${wave}j`st'isco88=	1229	if ${wave}j`st'soc00==	1225	& j`st'semp==	2			& j`st'size==	6
replace ${wave}j`st'isco88=	1229	if ${wave}j`st'soc00==	1225	& j`st'semp==	2			& j`st'size==	7
replace ${wave}j`st'isco88=	1229	if ${wave}j`st'soc00==	1225	& j`st'semp==	2			& j`st'size==	8
replace ${wave}j`st'isco88=	1229	if ${wave}j`st'soc00==	1225	& j`st'semp==	2			& j`st'size==	9
replace ${wave}j`st'isco88=	1229	if ${wave}j`st'soc00==	1225	& j`st'semp==	2			& j`st'size==	10
replace ${wave}j`st'isco88=	-8	if ${wave}j`st'soc00==	1225	& j`st'semp==	2			& j`st'size==	11
replace ${wave}j`st'isco88=	-8	if ${wave}j`st'soc00==	1225	& j`st'semp==	2			& j`st'size==	-8
replace ${wave}j`st'isco88=	-8	if ${wave}j`st'soc00==	1225	& j`st'semp==	2			& j`st'size==	-9
replace ${wave}j`st'isco88=	1316	if ${wave}j`st'soc00==	1226	& j`st'semp==	1			& j`st'size==	1
replace ${wave}j`st'isco88=	1316	if ${wave}j`st'soc00==	1226	& j`st'semp==	1			& j`st'size==	2
replace ${wave}j`st'isco88=	1226	if ${wave}j`st'soc00==	1226	& j`st'semp==	1			& j`st'size==	3
replace ${wave}j`st'isco88=	1226	if ${wave}j`st'soc00==	1226	& j`st'semp==	1			& j`st'size==	4
replace ${wave}j`st'isco88=	1226	if ${wave}j`st'soc00==	1226	& j`st'semp==	1			& j`st'size==	5
replace ${wave}j`st'isco88=	1226	if ${wave}j`st'soc00==	1226	& j`st'semp==	1			& j`st'size==	6
replace ${wave}j`st'isco88=	1226	if ${wave}j`st'soc00==	1226	& j`st'semp==	1			& j`st'size==	7
replace ${wave}j`st'isco88=	1226	if ${wave}j`st'soc00==	1226	& j`st'semp==	1			& j`st'size==	8
replace ${wave}j`st'isco88=	1226	if ${wave}j`st'soc00==	1226	& j`st'semp==	1			& j`st'size==	9
replace ${wave}j`st'isco88=	1226	if ${wave}j`st'soc00==	1226	& j`st'semp==	1			& j`st'size==	10
replace ${wave}j`st'isco88=	-8	if ${wave}j`st'soc00==	1226	& j`st'semp==	1			& j`st'size==	11
replace ${wave}j`st'isco88=	-8	if ${wave}j`st'soc00==	1226	& j`st'semp==	1			& j`st'size==	-8
replace ${wave}j`st'isco88=	-8	if ${wave}j`st'soc00==	1226	& j`st'semp==	1			& j`st'size==	-2
replace ${wave}j`st'isco88=	-8	if ${wave}j`st'soc00==	1226	& j`st'semp==	1			& j`st'size==	-1
replace ${wave}j`st'isco88=	1316	if ${wave}j`st'soc00==	1226	& j`st'semp==	2	& jssize==	1		
replace ${wave}j`st'isco88=	1316	if ${wave}j`st'soc00==	1226	& j`st'semp==	2	& jssize==	2		
replace ${wave}j`st'isco88=	1226	if ${wave}j`st'soc00==	1226	& j`st'semp==	2	& jssize==	3		
replace ${wave}j`st'isco88=	1226	if ${wave}j`st'soc00==	1226	& j`st'semp==	2	& jssize==	4		
replace ${wave}j`st'isco88=	1226	if ${wave}j`st'soc00==	1226	& j`st'semp==	2	& jssize==	5		
replace ${wave}j`st'isco88=	1226	if ${wave}j`st'soc00==	1226	& j`st'semp==	2	& jssize==	6		
replace ${wave}j`st'isco88=	1226	if ${wave}j`st'soc00==	1226	& j`st'semp==	2	& jssize==	7		
replace ${wave}j`st'isco88=	1226	if ${wave}j`st'soc00==	1226	& j`st'semp==	2	& jssize==	8		
replace ${wave}j`st'isco88=	1226	if ${wave}j`st'soc00==	1226	& j`st'semp==	2	& jssize==	9		
replace ${wave}j`st'isco88=	1226	if ${wave}j`st'soc00==	1226	& j`st'semp==	2	& jssize==	10		
replace ${wave}j`st'isco88=	-8	if ${wave}j`st'soc00==	1226	& j`st'semp==	2	& jssize==	11		
replace ${wave}j`st'isco88=	-8	if ${wave}j`st'soc00==	1226	& j`st'semp==	2	& jssize==	-8		
replace ${wave}j`st'isco88=	-8	if ${wave}j`st'soc00==	1226	& j`st'semp==	2	& jssize==	-9		
replace ${wave}j`st'isco88=	1317	if ${wave}j`st'soc00==	1231	& j`st'semp==	1			& j`st'size==	1
replace ${wave}j`st'isco88=	1317	if ${wave}j`st'soc00==	1231	& j`st'semp==	1			& j`st'size==	2
replace ${wave}j`st'isco88=	1227	if ${wave}j`st'soc00==	1231	& j`st'semp==	1			& j`st'size==	3
replace ${wave}j`st'isco88=	1227	if ${wave}j`st'soc00==	1231	& j`st'semp==	1			& j`st'size==	4
replace ${wave}j`st'isco88=	1227	if ${wave}j`st'soc00==	1231	& j`st'semp==	1			& j`st'size==	5
replace ${wave}j`st'isco88=	1227	if ${wave}j`st'soc00==	1231	& j`st'semp==	1			& j`st'size==	6
replace ${wave}j`st'isco88=	1227	if ${wave}j`st'soc00==	1231	& j`st'semp==	1			& j`st'size==	7
replace ${wave}j`st'isco88=	1227	if ${wave}j`st'soc00==	1231	& j`st'semp==	1			& j`st'size==	8
replace ${wave}j`st'isco88=	1227	if ${wave}j`st'soc00==	1231	& j`st'semp==	1			& j`st'size==	9
replace ${wave}j`st'isco88=	1227	if ${wave}j`st'soc00==	1231	& j`st'semp==	1			& j`st'size==	10
replace ${wave}j`st'isco88=	-8	if ${wave}j`st'soc00==	1231	& j`st'semp==	1			& j`st'size==	11
replace ${wave}j`st'isco88=	-8	if ${wave}j`st'soc00==	1231	& j`st'semp==	1			& j`st'size==	-8
replace ${wave}j`st'isco88=	-8	if ${wave}j`st'soc00==	1231	& j`st'semp==	1			& j`st'size==	-2
replace ${wave}j`st'isco88=	-8	if ${wave}j`st'soc00==	1231	& j`st'semp==	1			& j`st'size==	-1
replace ${wave}j`st'isco88=	1317	if ${wave}j`st'soc00==	1231	& j`st'semp==	2	& jssize==	1		
replace ${wave}j`st'isco88=	1317	if ${wave}j`st'soc00==	1231	& j`st'semp==	2	& jssize==	2		
replace ${wave}j`st'isco88=	1227	if ${wave}j`st'soc00==	1231	& j`st'semp==	2	& jssize==	3		
replace ${wave}j`st'isco88=	1227	if ${wave}j`st'soc00==	1231	& j`st'semp==	2	& jssize==	4		
replace ${wave}j`st'isco88=	1227	if ${wave}j`st'soc00==	1231	& j`st'semp==	2	& jssize==	5		
replace ${wave}j`st'isco88=	1227	if ${wave}j`st'soc00==	1231	& j`st'semp==	2	& jssize==	6		
replace ${wave}j`st'isco88=	1227	if ${wave}j`st'soc00==	1231	& j`st'semp==	2	& jssize==	7		
replace ${wave}j`st'isco88=	1227	if ${wave}j`st'soc00==	1231	& j`st'semp==	2	& jssize==	8		
replace ${wave}j`st'isco88=	1227	if ${wave}j`st'soc00==	1231	& j`st'semp==	2	& jssize==	9		
replace ${wave}j`st'isco88=	1227	if ${wave}j`st'soc00==	1231	& j`st'semp==	2	& jssize==	10		
replace ${wave}j`st'isco88=	-8	if ${wave}j`st'soc00==	1231	& j`st'semp==	2	& jssize==	11		
replace ${wave}j`st'isco88=	-8	if ${wave}j`st'soc00==	1231	& j`st'semp==	2	& jssize==	-8		
replace ${wave}j`st'isco88=	-8	if ${wave}j`st'soc00==	1231	& j`st'semp==	2	& jssize==	-9		
replace ${wave}j`st'isco88=	1314	if ${wave}j`st'soc00==	1232	& j`st'semp==	1			& j`st'size==	1
replace ${wave}j`st'isco88=	1314	if ${wave}j`st'soc00==	1232	& j`st'semp==	1			& j`st'size==	2
replace ${wave}j`st'isco88=	1224	if ${wave}j`st'soc00==	1232	& j`st'semp==	1			& j`st'size==	3
replace ${wave}j`st'isco88=	1224	if ${wave}j`st'soc00==	1232	& j`st'semp==	1			& j`st'size==	4
replace ${wave}j`st'isco88=	1224	if ${wave}j`st'soc00==	1232	& j`st'semp==	1			& j`st'size==	5
replace ${wave}j`st'isco88=	1224	if ${wave}j`st'soc00==	1232	& j`st'semp==	1			& j`st'size==	6
replace ${wave}j`st'isco88=	1224	if ${wave}j`st'soc00==	1232	& j`st'semp==	1			& j`st'size==	7
replace ${wave}j`st'isco88=	1224	if ${wave}j`st'soc00==	1232	& j`st'semp==	1			& j`st'size==	8
replace ${wave}j`st'isco88=	1224	if ${wave}j`st'soc00==	1232	& j`st'semp==	1			& j`st'size==	9
replace ${wave}j`st'isco88=	1224	if ${wave}j`st'soc00==	1232	& j`st'semp==	1			& j`st'size==	10
replace ${wave}j`st'isco88=	-8	if ${wave}j`st'soc00==	1232	& j`st'semp==	1			& j`st'size==	11
replace ${wave}j`st'isco88=	-8	if ${wave}j`st'soc00==	1232	& j`st'semp==	1			& j`st'size==	-8
replace ${wave}j`st'isco88=	-8	if ${wave}j`st'soc00==	1232	& j`st'semp==	1			& j`st'size==	-2
replace ${wave}j`st'isco88=	-8	if ${wave}j`st'soc00==	1232	& j`st'semp==	1			& j`st'size==	-1
replace ${wave}j`st'isco88=	1314	if ${wave}j`st'soc00==	1232	& j`st'semp==	2	& jssize==	1		
replace ${wave}j`st'isco88=	1314	if ${wave}j`st'soc00==	1232	& j`st'semp==	2	& jssize==	2		
replace ${wave}j`st'isco88=	1224	if ${wave}j`st'soc00==	1232	& j`st'semp==	2	& jssize==	3		
replace ${wave}j`st'isco88=	1224	if ${wave}j`st'soc00==	1232	& j`st'semp==	2	& jssize==	4		
replace ${wave}j`st'isco88=	1224	if ${wave}j`st'soc00==	1232	& j`st'semp==	2	& jssize==	5		
replace ${wave}j`st'isco88=	1224	if ${wave}j`st'soc00==	1232	& j`st'semp==	2	& jssize==	6		
replace ${wave}j`st'isco88=	1224	if ${wave}j`st'soc00==	1232	& j`st'semp==	2	& jssize==	7		
replace ${wave}j`st'isco88=	1224	if ${wave}j`st'soc00==	1232	& j`st'semp==	2	& jssize==	8		
replace ${wave}j`st'isco88=	1224	if ${wave}j`st'soc00==	1232	& j`st'semp==	2	& jssize==	9		
replace ${wave}j`st'isco88=	1224	if ${wave}j`st'soc00==	1232	& j`st'semp==	2	& jssize==	10		
replace ${wave}j`st'isco88=	-8	if ${wave}j`st'soc00==	1232	& j`st'semp==	2	& jssize==	11		
replace ${wave}j`st'isco88=	-8	if ${wave}j`st'soc00==	1232	& j`st'semp==	2	& jssize==	-8		
replace ${wave}j`st'isco88=	-8	if ${wave}j`st'soc00==	1232	& j`st'semp==	2	& jssize==	-9		
replace ${wave}j`st'isco88=	1318	if ${wave}j`st'soc00==	1233	& j`st'semp==	1			& j`st'size==	1
replace ${wave}j`st'isco88=	1318	if ${wave}j`st'soc00==	1233	& j`st'semp==	1			& j`st'size==	2
replace ${wave}j`st'isco88=	1228	if ${wave}j`st'soc00==	1233	& j`st'semp==	1			& j`st'size==	3
replace ${wave}j`st'isco88=	1228	if ${wave}j`st'soc00==	1233	& j`st'semp==	1			& j`st'size==	4
replace ${wave}j`st'isco88=	1228	if ${wave}j`st'soc00==	1233	& j`st'semp==	1			& j`st'size==	5
replace ${wave}j`st'isco88=	1228	if ${wave}j`st'soc00==	1233	& j`st'semp==	1			& j`st'size==	6
replace ${wave}j`st'isco88=	1228	if ${wave}j`st'soc00==	1233	& j`st'semp==	1			& j`st'size==	7
replace ${wave}j`st'isco88=	1228	if ${wave}j`st'soc00==	1233	& j`st'semp==	1			& j`st'size==	8
replace ${wave}j`st'isco88=	1228	if ${wave}j`st'soc00==	1233	& j`st'semp==	1			& j`st'size==	9
replace ${wave}j`st'isco88=	1228	if ${wave}j`st'soc00==	1233	& j`st'semp==	1			& j`st'size==	10
replace ${wave}j`st'isco88=	-8	if ${wave}j`st'soc00==	1233	& j`st'semp==	1			& j`st'size==	11
replace ${wave}j`st'isco88=	-8	if ${wave}j`st'soc00==	1233	& j`st'semp==	1			& j`st'size==	-8
replace ${wave}j`st'isco88=	-8	if ${wave}j`st'soc00==	1233	& j`st'semp==	1			& j`st'size==	-2
replace ${wave}j`st'isco88=	-8	if ${wave}j`st'soc00==	1233	& j`st'semp==	1			& j`st'size==	-1
replace ${wave}j`st'isco88=	1318	if ${wave}j`st'soc00==	1233	& j`st'semp==	2	& jssize==	1		
replace ${wave}j`st'isco88=	1318	if ${wave}j`st'soc00==	1233	& j`st'semp==	2	& jssize==	2		
replace ${wave}j`st'isco88=	1228	if ${wave}j`st'soc00==	1233	& j`st'semp==	2	& jssize==	3		
replace ${wave}j`st'isco88=	1228	if ${wave}j`st'soc00==	1233	& j`st'semp==	2	& jssize==	4		
replace ${wave}j`st'isco88=	1228	if ${wave}j`st'soc00==	1233	& j`st'semp==	2	& jssize==	5		
replace ${wave}j`st'isco88=	1228	if ${wave}j`st'soc00==	1233	& j`st'semp==	2	& jssize==	6		
replace ${wave}j`st'isco88=	1228	if ${wave}j`st'soc00==	1233	& j`st'semp==	2	& jssize==	7		
replace ${wave}j`st'isco88=	1228	if ${wave}j`st'soc00==	1233	& j`st'semp==	2	& jssize==	8		
replace ${wave}j`st'isco88=	1228	if ${wave}j`st'soc00==	1233	& j`st'semp==	2	& jssize==	9		
replace ${wave}j`st'isco88=	1228	if ${wave}j`st'soc00==	1233	& j`st'semp==	2	& jssize==	10		
replace ${wave}j`st'isco88=	-8	if ${wave}j`st'soc00==	1233	& j`st'semp==	2	& jssize==	11		
replace ${wave}j`st'isco88=	-8	if ${wave}j`st'soc00==	1233	& j`st'semp==	2	& jssize==	-8		
replace ${wave}j`st'isco88=	-8	if ${wave}j`st'soc00==	1233	& j`st'semp==	2	& jssize==	-9		
replace ${wave}j`st'isco88=	1319	if ${wave}j`st'soc00==	1235	& j`st'semp==	1			& j`st'size==	1
replace ${wave}j`st'isco88=	1319	if ${wave}j`st'soc00==	1235	& j`st'semp==	1			& j`st'size==	2
replace ${wave}j`st'isco88=	1229	if ${wave}j`st'soc00==	1235	& j`st'semp==	1			& j`st'size==	3
replace ${wave}j`st'isco88=	1229	if ${wave}j`st'soc00==	1235	& j`st'semp==	1			& j`st'size==	4
replace ${wave}j`st'isco88=	1229	if ${wave}j`st'soc00==	1235	& j`st'semp==	1			& j`st'size==	5
replace ${wave}j`st'isco88=	1229	if ${wave}j`st'soc00==	1235	& j`st'semp==	1			& j`st'size==	6
replace ${wave}j`st'isco88=	1229	if ${wave}j`st'soc00==	1235	& j`st'semp==	1			& j`st'size==	7
replace ${wave}j`st'isco88=	1229	if ${wave}j`st'soc00==	1235	& j`st'semp==	1			& j`st'size==	8
replace ${wave}j`st'isco88=	1229	if ${wave}j`st'soc00==	1235	& j`st'semp==	1			& j`st'size==	9
replace ${wave}j`st'isco88=	1229	if ${wave}j`st'soc00==	1235	& j`st'semp==	1			& j`st'size==	10
replace ${wave}j`st'isco88=	-8	if ${wave}j`st'soc00==	1235	& j`st'semp==	1			& j`st'size==	11
replace ${wave}j`st'isco88=	-8	if ${wave}j`st'soc00==	1235	& j`st'semp==	1			& j`st'size==	-8
replace ${wave}j`st'isco88=	-8	if ${wave}j`st'soc00==	1235	& j`st'semp==	1			& j`st'size==	-2
replace ${wave}j`st'isco88=	-8	if ${wave}j`st'soc00==	1235	& j`st'semp==	1			& j`st'size==	-1
replace ${wave}j`st'isco88=	1319	if ${wave}j`st'soc00==	1235	& j`st'semp==	2	& jssize==	1		
replace ${wave}j`st'isco88=	1319	if ${wave}j`st'soc00==	1235	& j`st'semp==	2	& jssize==	2		
replace ${wave}j`st'isco88=	1229	if ${wave}j`st'soc00==	1235	& j`st'semp==	2	& jssize==	3		
replace ${wave}j`st'isco88=	1229	if ${wave}j`st'soc00==	1235	& j`st'semp==	2	& jssize==	4		
replace ${wave}j`st'isco88=	1229	if ${wave}j`st'soc00==	1235	& j`st'semp==	2	& jssize==	5		
replace ${wave}j`st'isco88=	1229	if ${wave}j`st'soc00==	1235	& j`st'semp==	2	& jssize==	6		
replace ${wave}j`st'isco88=	1229	if ${wave}j`st'soc00==	1235	& j`st'semp==	2	& jssize==	7		
replace ${wave}j`st'isco88=	1229	if ${wave}j`st'soc00==	1235	& j`st'semp==	2	& jssize==	8		
replace ${wave}j`st'isco88=	1229	if ${wave}j`st'soc00==	1235	& j`st'semp==	2	& jssize==	9		
replace ${wave}j`st'isco88=	1229	if ${wave}j`st'soc00==	1235	& j`st'semp==	2	& jssize==	10		
replace ${wave}j`st'isco88=	-8	if ${wave}j`st'soc00==	1235	& j`st'semp==	2	& jssize==	11		
replace ${wave}j`st'isco88=	-8	if ${wave}j`st'soc00==	1235	& j`st'semp==	2	& jssize==	-8		
replace ${wave}j`st'isco88=	-8	if ${wave}j`st'soc00==	1235	& j`st'semp==	2	& jssize==	-9		
replace ${wave}j`st'isco88=	1319	if ${wave}j`st'soc00==	1239	& j`st'semp==	1			& j`st'size==	1
replace ${wave}j`st'isco88=	1319	if ${wave}j`st'soc00==	1239	& j`st'semp==	1			& j`st'size==	2
replace ${wave}j`st'isco88=	1229	if ${wave}j`st'soc00==	1239	& j`st'semp==	1			& j`st'size==	3
replace ${wave}j`st'isco88=	1229	if ${wave}j`st'soc00==	1239	& j`st'semp==	1			& j`st'size==	4
replace ${wave}j`st'isco88=	1229	if ${wave}j`st'soc00==	1239	& j`st'semp==	1			& j`st'size==	5
replace ${wave}j`st'isco88=	1229	if ${wave}j`st'soc00==	1239	& j`st'semp==	1			& j`st'size==	6
replace ${wave}j`st'isco88=	1229	if ${wave}j`st'soc00==	1239	& j`st'semp==	1			& j`st'size==	7
replace ${wave}j`st'isco88=	1229	if ${wave}j`st'soc00==	1239	& j`st'semp==	1			& j`st'size==	8
replace ${wave}j`st'isco88=	1229	if ${wave}j`st'soc00==	1239	& j`st'semp==	1			& j`st'size==	9
replace ${wave}j`st'isco88=	1229	if ${wave}j`st'soc00==	1239	& j`st'semp==	1			& j`st'size==	10
replace ${wave}j`st'isco88=	-8	if ${wave}j`st'soc00==	1239	& j`st'semp==	1			& j`st'size==	11
replace ${wave}j`st'isco88=	-8	if ${wave}j`st'soc00==	1239	& j`st'semp==	1			& j`st'size==	-8
replace ${wave}j`st'isco88=	-8	if ${wave}j`st'soc00==	1239	& j`st'semp==	1			& j`st'size==	-2
replace ${wave}j`st'isco88=	-8	if ${wave}j`st'soc00==	1239	& j`st'semp==	1			& j`st'size==	-1
replace ${wave}j`st'isco88=	1319	if ${wave}j`st'soc00==	1239	& j`st'semp==	2	& jssize==	1		
replace ${wave}j`st'isco88=	1319	if ${wave}j`st'soc00==	1239	& j`st'semp==	2	& jssize==	2		
replace ${wave}j`st'isco88=	1229	if ${wave}j`st'soc00==	1239	& j`st'semp==	2	& jssize==	3		
replace ${wave}j`st'isco88=	1229	if ${wave}j`st'soc00==	1239	& j`st'semp==	2	& jssize==	4		
replace ${wave}j`st'isco88=	1229	if ${wave}j`st'soc00==	1239	& j`st'semp==	2	& jssize==	5		
replace ${wave}j`st'isco88=	1229	if ${wave}j`st'soc00==	1239	& j`st'semp==	2	& jssize==	6		
replace ${wave}j`st'isco88=	1229	if ${wave}j`st'soc00==	1239	& j`st'semp==	2	& jssize==	7		
replace ${wave}j`st'isco88=	1229	if ${wave}j`st'soc00==	1239	& j`st'semp==	2	& jssize==	8		
replace ${wave}j`st'isco88=	1229	if ${wave}j`st'soc00==	1239	& j`st'semp==	2	& jssize==	9		
replace ${wave}j`st'isco88=	1229	if ${wave}j`st'soc00==	1239	& j`st'semp==	2	& jssize==	10		
replace ${wave}j`st'isco88=	-8	if ${wave}j`st'soc00==	1239	& j`st'semp==	2	& jssize==	11		
replace ${wave}j`st'isco88=	-8	if ${wave}j`st'soc00==	1239	& j`st'semp==	2	& jssize==	-8		
replace ${wave}j`st'isco88=	-8	if ${wave}j`st'soc00==	1239	& j`st'semp==	2	& jssize==	-9		
replace ${wave}j`st'isco88=	1229	if ${wave}j`st'soc00==	1173						
replace ${wave}j`st'isco88=	1239	if ${wave}j`st'soc00==	1174						
replace ${wave}j`st'isco88=	1229	if ${wave}j`st'soc00==	1181						
replace ${wave}j`st'isco88=	1229	if ${wave}j`st'soc00==	1184						
replace ${wave}j`st'isco88=	1231	if ${wave}j`st'soc00==	1152						
replace ${wave}j`st'isco88=	100	if ${wave}j`st'soc00==	1171						
replace ${wave}j`st'isco88=	3450	if ${wave}j`st'soc00==	1172						
replace ${wave}j`st'isco88=	1314	if ${wave}j`st'soc00==	1234						
replace ${wave}j`st'isco88=	2113	if ${wave}j`st'soc00==	2111						
replace ${wave}j`st'isco88=	2211	if ${wave}j`st'soc00==	2112						
replace ${wave}j`st'isco88=	2110	if ${wave}j`st'soc00==	2113						
replace ${wave}j`st'isco88=	2142	if ${wave}j`st'soc00==	2121						
replace ${wave}j`st'isco88=	2145	if ${wave}j`st'soc00==	2122						
replace ${wave}j`st'isco88=	2143	if ${wave}j`st'soc00==	2123						
replace ${wave}j`st'isco88=	2144	if ${wave}j`st'soc00==	2124						
replace ${wave}j`st'isco88=	2146	if ${wave}j`st'soc00==	2125						
replace ${wave}j`st'isco88=	2149	if ${wave}j`st'soc00==	2126						
replace ${wave}j`st'isco88=	2149	if ${wave}j`st'soc00==	2127						
replace ${wave}j`st'isco88=	2149	if ${wave}j`st'soc00==	2128						
replace ${wave}j`st'isco88=	2149	if ${wave}j`st'soc00==	2129						
replace ${wave}j`st'isco88=	2130	if ${wave}j`st'soc00==	2131						
replace ${wave}j`st'isco88=	2130	if ${wave}j`st'soc00==	2132						
replace ${wave}j`st'isco88=	2221	if ${wave}j`st'soc00==	2211						
replace ${wave}j`st'isco88=	2445	if ${wave}j`st'soc00==	2212						
replace ${wave}j`st'isco88=	2224	if ${wave}j`st'soc00==	2213						
replace ${wave}j`st'isco88=	2229	if ${wave}j`st'soc00==	2214						
replace ${wave}j`st'isco88=	2222	if ${wave}j`st'soc00==	2215						
replace ${wave}j`st'isco88=	2223	if ${wave}j`st'soc00==	2216						
replace ${wave}j`st'isco88=	2310	if ${wave}j`st'soc00==	2311						
replace ${wave}j`st'isco88=	2310	if ${wave}j`st'soc00==	2312						
replace ${wave}j`st'isco88=	2352	if ${wave}j`st'soc00==	2313						
replace ${wave}j`st'isco88=	2320	if ${wave}j`st'soc00==	2314						
replace ${wave}j`st'isco88=	2330	if ${wave}j`st'soc00==	2315						
replace ${wave}j`st'isco88=	2340	if ${wave}j`st'soc00==	2316						
replace ${wave}j`st'isco88=	2359	if ${wave}j`st'soc00==	2317						
replace ${wave}j`st'isco88=	2359	if ${wave}j`st'soc00==	2319						
replace ${wave}j`st'isco88=	2110	if ${wave}j`st'soc00==	2321						
replace ${wave}j`st'isco88=	2440	if ${wave}j`st'soc00==	2322						
replace ${wave}j`st'isco88=	2310	if ${wave}j`st'soc00==	2329						
replace ${wave}j`st'isco88=	2420	if ${wave}j`st'soc00==	2411						
replace ${wave}j`st'isco88=	2429	if ${wave}j`st'soc00==	2419						
replace ${wave}j`st'isco88=	2411	if ${wave}j`st'soc00==	2421						
replace ${wave}j`st'isco88=	2411	if ${wave}j`st'soc00==	2422						
replace ${wave}j`st'isco88=	2419	if ${wave}j`st'soc00==	2423						
replace ${wave}j`st'isco88=	2141	if ${wave}j`st'soc00==	2431						
replace ${wave}j`st'isco88=	2141	if ${wave}j`st'soc00==	2432						
replace ${wave}j`st'isco88=	2148	if ${wave}j`st'soc00==	2433						
replace ${wave}j`st'isco88=	2148	if ${wave}j`st'soc00==	2434						
replace ${wave}j`st'isco88=	2470	if ${wave}j`st'soc00==	2441						
replace ${wave}j`st'isco88=	2446	if ${wave}j`st'soc00==	2442						
replace ${wave}j`st'isco88=	2446	if ${wave}j`st'soc00==	2443						
replace ${wave}j`st'isco88=	2460	if ${wave}j`st'soc00==	2444						
replace ${wave}j`st'isco88=	2432	if ${wave}j`st'soc00==	2451						
replace ${wave}j`st'isco88=	2431	if ${wave}j`st'soc00==	2452						
replace ${wave}j`st'isco88=	3111	if ${wave}j`st'soc00==	3111						
replace ${wave}j`st'isco88=	3114	if ${wave}j`st'soc00==	3112						
replace ${wave}j`st'isco88=	3110	if ${wave}j`st'soc00==	3113						
replace ${wave}j`st'isco88=	3112	if ${wave}j`st'soc00==	3114						
replace ${wave}j`st'isco88=	3119	if ${wave}j`st'soc00==	3115						
replace ${wave}j`st'isco88=	3119	if ${wave}j`st'soc00==	3119						
replace ${wave}j`st'isco88=	3119	if ${wave}j`st'soc00==	3121						
replace ${wave}j`st'isco88=	3118	if ${wave}j`st'soc00==	3122						
replace ${wave}j`st'isco88=	3151	if ${wave}j`st'soc00==	3123						
replace ${wave}j`st'isco88=	3120	if ${wave}j`st'soc00==	3131						
replace ${wave}j`st'isco88=	3120	if ${wave}j`st'soc00==	3132						
replace ${wave}j`st'isco88=	3231	if ${wave}j`st'soc00==	3211						
replace ${wave}j`st'isco88=	3232	if ${wave}j`st'soc00==	3212						
replace ${wave}j`st'isco88=	3221	if ${wave}j`st'soc00==	3213						
replace ${wave}j`st'isco88=	3133	if ${wave}j`st'soc00==	3214						
replace ${wave}j`st'isco88=	3226	if ${wave}j`st'soc00==	3215						
replace ${wave}j`st'isco88=	3224	if ${wave}j`st'soc00==	3216						
replace ${wave}j`st'isco88=	3228	if ${wave}j`st'soc00==	3217						
replace ${wave}j`st'isco88=	3220	if ${wave}j`st'soc00==	3218						
replace ${wave}j`st'isco88=	3226	if ${wave}j`st'soc00==	3221						
replace ${wave}j`st'isco88=	3226	if ${wave}j`st'soc00==	3222						
replace ${wave}j`st'isco88=	3226	if ${wave}j`st'soc00==	3223						
replace ${wave}j`st'isco88=	3226	if ${wave}j`st'soc00==	3229						
replace ${wave}j`st'isco88=	3460	if ${wave}j`st'soc00==	3231						
replace ${wave}j`st'isco88=	3460	if ${wave}j`st'soc00==	3232						
replace ${wave}j`st'isco88=	100	if ${wave}j`st'soc00==	3311						
replace ${wave}j`st'isco88=	5162	if ${wave}j`st'soc00==	3312						
replace ${wave}j`st'isco88=	5161	if ${wave}j`st'soc00==	3313						
replace ${wave}j`st'isco88=	5163	if ${wave}j`st'soc00==	3314						
replace ${wave}j`st'isco88=	5169	if ${wave}j`st'soc00==	3319						
replace ${wave}j`st'isco88=	2452	if ${wave}j`st'soc00==	3411						
replace ${wave}j`st'isco88=	2451	if ${wave}j`st'soc00==	3412						
replace ${wave}j`st'isco88=	3470	if ${wave}j`st'soc00==	3413						
replace ${wave}j`st'isco88=	3473	if ${wave}j`st'soc00==	3414						
replace ${wave}j`st'isco88=	3473	if ${wave}j`st'soc00==	3415						
replace ${wave}j`st'isco88=	2455	if ${wave}j`st'soc00==	3416						
replace ${wave}j`st'isco88=	3471	if ${wave}j`st'soc00==	3421						
replace ${wave}j`st'isco88=	3471	if ${wave}j`st'soc00==	3422						
replace ${wave}j`st'isco88=	2451	if ${wave}j`st'soc00==	3431						
replace ${wave}j`st'isco88=	3472	if ${wave}j`st'soc00==	3432						
replace ${wave}j`st'isco88=	3419	if ${wave}j`st'soc00==	3433						
replace ${wave}j`st'isco88=	3131	if ${wave}j`st'soc00==	3434						
replace ${wave}j`st'isco88=	3475	if ${wave}j`st'soc00==	3441						
replace ${wave}j`st'isco88=	3475	if ${wave}j`st'soc00==	3442						
replace ${wave}j`st'isco88=	3475	if ${wave}j`st'soc00==	3443						
replace ${wave}j`st'isco88=	3475	if ${wave}j`st'soc00==	3449						
replace ${wave}j`st'isco88=	3144	if ${wave}j`st'soc00==	3511						
replace ${wave}j`st'isco88=	3143	if ${wave}j`st'soc00==	3512						
replace ${wave}j`st'isco88=	3142	if ${wave}j`st'soc00==	3513						
replace ${wave}j`st'isco88=	8311	if ${wave}j`st'soc00==	3514						
replace ${wave}j`st'isco88=	3432	if ${wave}j`st'soc00==	3520						
replace ${wave}j`st'isco88=	3417	if ${wave}j`st'soc00==	3531						
replace ${wave}j`st'isco88=	3411	if ${wave}j`st'soc00==	3532						
replace ${wave}j`st'isco88=	3412	if ${wave}j`st'soc00==	3533						
replace ${wave}j`st'isco88=	3419	if ${wave}j`st'soc00==	3534						
replace ${wave}j`st'isco88=	3442	if ${wave}j`st'soc00==	3535						
replace ${wave}j`st'isco88=	3422	if ${wave}j`st'soc00==	3536						
replace ${wave}j`st'isco88=	3433	if ${wave}j`st'soc00==	3537						
replace ${wave}j`st'isco88=	3419	if ${wave}j`st'soc00==	3539						
replace ${wave}j`st'isco88=	3416	if ${wave}j`st'soc00==	3541						
replace ${wave}j`st'isco88=	3415	if ${wave}j`st'soc00==	3542						
replace ${wave}j`st'isco88=	3419	if ${wave}j`st'soc00==	3543						
replace ${wave}j`st'isco88=	3413	if ${wave}j`st'soc00==	3544						
replace ${wave}j`st'isco88=	3210	if ${wave}j`st'soc00==	3551						
replace ${wave}j`st'isco88=	3210	if ${wave}j`st'soc00==	3552						
replace ${wave}j`st'isco88=	3449	if ${wave}j`st'soc00==	3561						
replace ${wave}j`st'isco88=	2412	if ${wave}j`st'soc00==	3562						
replace ${wave}j`st'isco88=	3340	if ${wave}j`st'soc00==	3563						
replace ${wave}j`st'isco88=	2412	if ${wave}j`st'soc00==	3564						
replace ${wave}j`st'isco88=	3152	if ${wave}j`st'soc00==	3565						
replace ${wave}j`st'isco88=	3152	if ${wave}j`st'soc00==	3566						
replace ${wave}j`st'isco88=	3152	if ${wave}j`st'soc00==	3567						
replace ${wave}j`st'isco88=	3152	if ${wave}j`st'soc00==	3568						
replace ${wave}j`st'isco88=	4190	if ${wave}j`st'soc00==	4111						
replace ${wave}j`st'isco88=	4190	if ${wave}j`st'soc00==	4112						
replace ${wave}j`st'isco88=	4190	if ${wave}j`st'soc00==	4113						
replace ${wave}j`st'isco88=	4190	if ${wave}j`st'soc00==	4114						
replace ${wave}j`st'isco88=	4120	if ${wave}j`st'soc00==	4121						
replace ${wave}j`st'isco88=	4120	if ${wave}j`st'soc00==	4122						
replace ${wave}j`st'isco88=	4210	if ${wave}j`st'soc00==	4123						
replace ${wave}j`st'isco88=	4141	if ${wave}j`st'soc00==	4131						
replace ${wave}j`st'isco88=	4190	if ${wave}j`st'soc00==	4132						
replace ${wave}j`st'isco88=	4131	if ${wave}j`st'soc00==	4133						
replace ${wave}j`st'isco88=	4133	if ${wave}j`st'soc00==	4134						
replace ${wave}j`st'isco88=	4141	if ${wave}j`st'soc00==	4135						
replace ${wave}j`st'isco88=	4113	if ${wave}j`st'soc00==	4136						
replace ${wave}j`st'isco88=	4190	if ${wave}j`st'soc00==	4137						
replace ${wave}j`st'isco88=	4223	if ${wave}j`st'soc00==	4141						
replace ${wave}j`st'isco88=	4223	if ${wave}j`st'soc00==	4142						
replace ${wave}j`st'isco88=	4190	if ${wave}j`st'soc00==	4150						
replace ${wave}j`st'isco88=	4115	if ${wave}j`st'soc00==	4211						
replace ${wave}j`st'isco88=	4115	if ${wave}j`st'soc00==	4212						
replace ${wave}j`st'isco88=	4115	if ${wave}j`st'soc00==	4213						
replace ${wave}j`st'isco88=	4115	if ${wave}j`st'soc00==	4214						
replace ${wave}j`st'isco88=	4115	if ${wave}j`st'soc00==	4215						
replace ${wave}j`st'isco88=	4222	if ${wave}j`st'soc00==	4216						
replace ${wave}j`st'isco88=	4110	if ${wave}j`st'soc00==	4217						
replace ${wave}j`st'isco88=	6130	if ${wave}j`st'soc00==	5111						
replace ${wave}j`st'isco88=	6112	if ${wave}j`st'soc00==	5112						
replace ${wave}j`st'isco88=	6112	if ${wave}j`st'soc00==	5113						
replace ${wave}j`st'isco88=	6150	if ${wave}j`st'soc00==	5119						
replace ${wave}j`st'isco88=	7221	if ${wave}j`st'soc00==	5211						
replace ${wave}j`st'isco88=	7211	if ${wave}j`st'soc00==	5212						
replace ${wave}j`st'isco88=	7213	if ${wave}j`st'soc00==	5213						
replace ${wave}j`st'isco88=	7214	if ${wave}j`st'soc00==	5214						
replace ${wave}j`st'isco88=	7212	if ${wave}j`st'soc00==	5215						
replace ${wave}j`st'isco88=	7136	if ${wave}j`st'soc00==	5216						
replace ${wave}j`st'isco88=	7223	if ${wave}j`st'soc00==	5221						
replace ${wave}j`st'isco88=	7222	if ${wave}j`st'soc00==	5222						
replace ${wave}j`st'isco88=	7230	if ${wave}j`st'soc00==	5223						
replace ${wave}j`st'isco88=	7311	if ${wave}j`st'soc00==	5224						
replace ${wave}j`st'isco88=	7231	if ${wave}j`st'soc00==	5231						
replace ${wave}j`st'isco88=	7213	if ${wave}j`st'soc00==	5232						
replace ${wave}j`st'isco88=	7241	if ${wave}j`st'soc00==	5233						
replace ${wave}j`st'isco88=	7141	if ${wave}j`st'soc00==	5234						
replace ${wave}j`st'isco88=	7137	if ${wave}j`st'soc00==	5241						
replace ${wave}j`st'isco88=	7244	if ${wave}j`st'soc00==	5242						
replace ${wave}j`st'isco88=	7245	if ${wave}j`st'soc00==	5243						
replace ${wave}j`st'isco88=	7242	if ${wave}j`st'soc00==	5244						
replace ${wave}j`st'isco88=	7242	if ${wave}j`st'soc00==	5245						
replace ${wave}j`st'isco88=	7242	if ${wave}j`st'soc00==	5249						
replace ${wave}j`st'isco88=	7214	if ${wave}j`st'soc00==	5311						
replace ${wave}j`st'isco88=	7122	if ${wave}j`st'soc00==	5312						
replace ${wave}j`st'isco88=	7131	if ${wave}j`st'soc00==	5313						
replace ${wave}j`st'isco88=	7136	if ${wave}j`st'soc00==	5314						
replace ${wave}j`st'isco88=	7124	if ${wave}j`st'soc00==	5315						
replace ${wave}j`st'isco88=	7135	if ${wave}j`st'soc00==	5316						
replace ${wave}j`st'isco88=	7121	if ${wave}j`st'soc00==	5319						
replace ${wave}j`st'isco88=	7133	if ${wave}j`st'soc00==	5321						
replace ${wave}j`st'isco88=	7132	if ${wave}j`st'soc00==	5322						
replace ${wave}j`st'isco88=	7141	if ${wave}j`st'soc00==	5323						
replace ${wave}j`st'isco88=	7432	if ${wave}j`st'soc00==	5411						
replace ${wave}j`st'isco88=	7437	if ${wave}j`st'soc00==	5412						
replace ${wave}j`st'isco88=	7442	if ${wave}j`st'soc00==	5413						
replace ${wave}j`st'isco88=	7433	if ${wave}j`st'soc00==	5414						
replace ${wave}j`st'isco88=	7430	if ${wave}j`st'soc00==	5419						
replace ${wave}j`st'isco88=	7341	if ${wave}j`st'soc00==	5421						
replace ${wave}j`st'isco88=	7341	if ${wave}j`st'soc00==	5422						
replace ${wave}j`st'isco88=	7345	if ${wave}j`st'soc00==	5423						
replace ${wave}j`st'isco88=	7346	if ${wave}j`st'soc00==	5424						
replace ${wave}j`st'isco88=	7411	if ${wave}j`st'soc00==	5431						
replace ${wave}j`st'isco88=	7412	if ${wave}j`st'soc00==	5432						
replace ${wave}j`st'isco88=	7411	if ${wave}j`st'soc00==	5433						
replace ${wave}j`st'isco88=	5122	if ${wave}j`st'soc00==	5434						
replace ${wave}j`st'isco88=	7320	if ${wave}j`st'soc00==	5491						
replace ${wave}j`st'isco88=	7422	if ${wave}j`st'soc00==	5492						
replace ${wave}j`st'isco88=	7422	if ${wave}j`st'soc00==	5493						
replace ${wave}j`st'isco88=	7312	if ${wave}j`st'soc00==	5494						
replace ${wave}j`st'isco88=	7313	if ${wave}j`st'soc00==	5495						
replace ${wave}j`st'isco88=	3471	if ${wave}j`st'soc00==	5496						
replace ${wave}j`st'isco88=	7330	if ${wave}j`st'soc00==	5499						
replace ${wave}j`st'isco88=	5132	if ${wave}j`st'soc00==	6111						
replace ${wave}j`st'isco88=	5132	if ${wave}j`st'soc00==	6112						
replace ${wave}j`st'isco88=	3225	if ${wave}j`st'soc00==	6113						
replace ${wave}j`st'isco88=	5132	if ${wave}j`st'soc00==	6114						
replace ${wave}j`st'isco88=	5133	if ${wave}j`st'soc00==	6115						
replace ${wave}j`st'isco88=	5131	if ${wave}j`st'soc00==	6121						
replace ${wave}j`st'isco88=	5131	if ${wave}j`st'soc00==	6122						
replace ${wave}j`st'isco88=	5131	if ${wave}j`st'soc00==	6123						
replace ${wave}j`st'isco88=	5131	if ${wave}j`st'soc00==	6124						
replace ${wave}j`st'isco88=	3227	if ${wave}j`st'soc00==	6131						
replace ${wave}j`st'isco88=	3227	if ${wave}j`st'soc00==	6139						
replace ${wave}j`st'isco88=	5149	if ${wave}j`st'soc00==	6211						
replace ${wave}j`st'isco88=	4221	if ${wave}j`st'soc00==	6212						
replace ${wave}j`st'isco88=	5113	if ${wave}j`st'soc00==	6213						
replace ${wave}j`st'isco88=	5111	if ${wave}j`st'soc00==	6214						
replace ${wave}j`st'isco88=	5112	if ${wave}j`st'soc00==	6215						
replace ${wave}j`st'isco88=	5110	if ${wave}j`st'soc00==	6219						
replace ${wave}j`st'isco88=	5141	if ${wave}j`st'soc00==	6221						
replace ${wave}j`st'isco88=	5141	if ${wave}j`st'soc00==	6222						
replace ${wave}j`st'isco88=	5121	if ${wave}j`st'soc00==	6231						
replace ${wave}j`st'isco88=	9141	if ${wave}j`st'soc00==	6232						
replace ${wave}j`st'isco88=	5143	if ${wave}j`st'soc00==	6291						
replace ${wave}j`st'isco88=	7143	if ${wave}j`st'soc00==	6292						
replace ${wave}j`st'isco88=	5220	if ${wave}j`st'soc00==	7111						
replace ${wave}j`st'isco88=	5220	if ${wave}j`st'soc00==	7112						
replace ${wave}j`st'isco88=	9113	if ${wave}j`st'soc00==	7113						
replace ${wave}j`st'isco88=	9113	if ${wave}j`st'soc00==	7121						
replace ${wave}j`st'isco88=	9153	if ${wave}j`st'soc00==	7122						
replace ${wave}j`st'isco88=	9113	if ${wave}j`st'soc00==	7123						
replace ${wave}j`st'isco88=	5220	if ${wave}j`st'soc00==	7124						
replace ${wave}j`st'isco88=	3471	if ${wave}j`st'soc00==	7125						
replace ${wave}j`st'isco88=	3415	if ${wave}j`st'soc00==	7129						
replace ${wave}j`st'isco88=	4220	if ${wave}j`st'soc00==	7211						
replace ${wave}j`st'isco88=	4220	if ${wave}j`st'soc00==	7212						
replace ${wave}j`st'isco88=	8270	if ${wave}j`st'soc00==	8111						
replace ${wave}j`st'isco88=	8130	if ${wave}j`st'soc00==	8112						
replace ${wave}j`st'isco88=	8260	if ${wave}j`st'soc00==	8113						
replace ${wave}j`st'isco88=	8150	if ${wave}j`st'soc00==	8114						
replace ${wave}j`st'isco88=	8231	if ${wave}j`st'soc00==	8115						
replace ${wave}j`st'isco88=	8232	if ${wave}j`st'soc00==	8116						
replace ${wave}j`st'isco88=	8120	if ${wave}j`st'soc00==	8117						
replace ${wave}j`st'isco88=	8223	if ${wave}j`st'soc00==	8118						
replace ${wave}j`st'isco88=	8100	if ${wave}j`st'soc00==	8119						
replace ${wave}j`st'isco88=	8140	if ${wave}j`st'soc00==	8121						
replace ${wave}j`st'isco88=	8111	if ${wave}j`st'soc00==	8122						
replace ${wave}j`st'isco88=	8112	if ${wave}j`st'soc00==	8123						
replace ${wave}j`st'isco88=	8160	if ${wave}j`st'soc00==	8124						
replace ${wave}j`st'isco88=	8211	if ${wave}j`st'soc00==	8125						
replace ${wave}j`st'isco88=	8163	if ${wave}j`st'soc00==	8126						
replace ${wave}j`st'isco88=	8290	if ${wave}j`st'soc00==	8129						
replace ${wave}j`st'isco88=	8282	if ${wave}j`st'soc00==	8131						
replace ${wave}j`st'isco88=	8281	if ${wave}j`st'soc00==	8132						
replace ${wave}j`st'isco88=	8290	if ${wave}j`st'soc00==	8133						
replace ${wave}j`st'isco88=	8290	if ${wave}j`st'soc00==	8134						
replace ${wave}j`st'isco88=	7231	if ${wave}j`st'soc00==	8135						
replace ${wave}j`st'isco88=	8269	if ${wave}j`st'soc00==	8136						
replace ${wave}j`st'isco88=	8263	if ${wave}j`st'soc00==	8137						
replace ${wave}j`st'isco88=	8290	if ${wave}j`st'soc00==	8138						
replace ${wave}j`st'isco88=	8290	if ${wave}j`st'soc00==	8139						
replace ${wave}j`st'isco88=	7129	if ${wave}j`st'soc00==	8141						
replace ${wave}j`st'isco88=	9312	if ${wave}j`st'soc00==	8142						
replace ${wave}j`st'isco88=	9312	if ${wave}j`st'soc00==	8143						
replace ${wave}j`st'isco88=	9313	if ${wave}j`st'soc00==	8149						
replace ${wave}j`st'isco88=	8324	if ${wave}j`st'soc00==	8211						
replace ${wave}j`st'isco88=	8322	if ${wave}j`st'soc00==	8212						
replace ${wave}j`st'isco88=	8323	if ${wave}j`st'soc00==	8213						
replace ${wave}j`st'isco88=	8322	if ${wave}j`st'soc00==	8214						
replace ${wave}j`st'isco88=	3340	if ${wave}j`st'soc00==	8215						
replace ${wave}j`st'isco88=	8312	if ${wave}j`st'soc00==	8216						
replace ${wave}j`st'isco88=	8340	if ${wave}j`st'soc00==	8217						
replace ${wave}j`st'isco88=	9330	if ${wave}j`st'soc00==	8218						
replace ${wave}j`st'isco88=	9330	if ${wave}j`st'soc00==	8219						
replace ${wave}j`st'isco88=	8333	if ${wave}j`st'soc00==	8221						
replace ${wave}j`st'isco88=	8334	if ${wave}j`st'soc00==	8222						
replace ${wave}j`st'isco88=	8331	if ${wave}j`st'soc00==	8223						
replace ${wave}j`st'isco88=	8330	if ${wave}j`st'soc00==	8229						
replace ${wave}j`st'isco88=	9211	if ${wave}j`st'soc00==	9111						
replace ${wave}j`st'isco88=	9212	if ${wave}j`st'soc00==	9112						
replace ${wave}j`st'isco88=	9210	if ${wave}j`st'soc00==	9119						
replace ${wave}j`st'isco88=	9313	if ${wave}j`st'soc00==	9121						
replace ${wave}j`st'isco88=	9312	if ${wave}j`st'soc00==	9129						
replace ${wave}j`st'isco88=	9320	if ${wave}j`st'soc00==	9131						
replace ${wave}j`st'isco88=	9132	if ${wave}j`st'soc00==	9132						
replace ${wave}j`st'isco88=	9320	if ${wave}j`st'soc00==	9133						
replace ${wave}j`st'isco88=	9320	if ${wave}j`st'soc00==	9134						
replace ${wave}j`st'isco88=	9320	if ${wave}j`st'soc00==	9139						
replace ${wave}j`st'isco88=	9330	if ${wave}j`st'soc00==	9141						
replace ${wave}j`st'isco88=	9330	if ${wave}j`st'soc00==	9149						
replace ${wave}j`st'isco88=	9151	if ${wave}j`st'soc00==	9211						
replace ${wave}j`st'isco88=	9151	if ${wave}j`st'soc00==	9219						
replace ${wave}j`st'isco88=	9132	if ${wave}j`st'soc00==	9221						
replace ${wave}j`st'isco88=	9150	if ${wave}j`st'soc00==	9222						
replace ${wave}j`st'isco88=	9132	if ${wave}j`st'soc00==	9223						
replace ${wave}j`st'isco88=	5123	if ${wave}j`st'soc00==	9224						
replace ${wave}j`st'isco88=	5123	if ${wave}j`st'soc00==	9225						
replace ${wave}j`st'isco88=	9152	if ${wave}j`st'soc00==	9226						
replace ${wave}j`st'isco88=	9150	if ${wave}j`st'soc00==	9229						
replace ${wave}j`st'isco88=	9142	if ${wave}j`st'soc00==	9231						
replace ${wave}j`st'isco88=	9162	if ${wave}j`st'soc00==	9232						
replace ${wave}j`st'isco88=	9130	if ${wave}j`st'soc00==	9233						
replace ${wave}j`st'isco88=	9131	if ${wave}j`st'soc00==	9233						
replace ${wave}j`st'isco88=	9133	if ${wave}j`st'soc00==	9234						
replace ${wave}j`st'isco88=	9161	if ${wave}j`st'soc00==	9235						
replace ${wave}j`st'isco88=	9162	if ${wave}j`st'soc00==	9239						
replace ${wave}j`st'isco88=	9152	if ${wave}j`st'soc00==	9241						
replace ${wave}j`st'isco88=	5169	if ${wave}j`st'soc00==	9242						
replace ${wave}j`st'isco88=	9152	if ${wave}j`st'soc00==	9243						
replace ${wave}j`st'isco88=	5131	if ${wave}j`st'soc00==	9244						
replace ${wave}j`st'isco88=	9152	if ${wave}j`st'soc00==	9245						
replace ${wave}j`st'isco88=	9152	if ${wave}j`st'soc00==	9249						
replace ${wave}j`st'isco88=	5220	if ${wave}j`st'soc00==	9251						
replace ${wave}j`st'isco88=	9151	if ${wave}j`st'soc00==	9259
}
// Assign correct missing values
keep pidp ${wave}jbisco88 ${wave}jlisco88 ivfio jbhas jboff jbhad
for var ${wave}jb* ${wave}jl*: recode X (.=-9)
for var ${wave}jb*: recode X (. -7 -9=-8) if jbhas~=1 & jboff~=1
for var ${wave}jl*: recode X (. -9=-8) if jbhad~=1 
// there are some codes for people who were not supposed to have last job info
for var ${wave}jl*: replace X =-8 if (jbhas~=2 & jboff~=2 & jbhad~=1)	
for var ${wave}jl*: recode X (. -9/-8=-7) if ivfio==2



* Recode ISCO 88 to 3-digit level
foreach cat in jb jl  {
gen ${wave}`cat'isco88_cc=int(${wave}`cat'isco88/10)
replace ${wave}`cat'isco88_cc=${wave}`cat'isco88 if ${wave}`cat'isco88_cc==0	
}
lab var ${wave}jbisco88_cc "Current job: ISCO88 (condensed 3 digits version)"
lab var ${wave}jlisco88_cc "Last job: ISCO88 (condensed 3 digits version)"
keep pidp ${wave}jbisco88 ${wave}jbisco88_cc ${wave}jlisco88 ${wave}jlisco88_cc

do "$outpath/isco88_lb"
do "$outpath/isco88_cc_lb"
save "$outpath/${wave}isco88", replace		
}


