
/******************************************************************************/

/*********  ~  Newly Diagnosed Conditions - Multilevel Models  ~  ************/

/***************************************************************************

	Stata:   WAVES (a - k)
	
			Last Refined 12th OCTOBER 2022, Amended SDS 31 OCT 2022
	
	By Sue Easton, LIIRH, University of Lincoln

	UKDS Project Number: 219223
	
	UKDS Study Number SN6614 (UKHLS, All Waves, 2009-2020)
	
	Understanding Society Fellowship
	
***************************************************************************/
// Creating directory paths  ***  EXCLUDED due to Drive Paths in SECURE AREA ***

global Logfiles ".....SDS....Working\STATA_LogFiles"

global Originals "....SDS....\stata\6676_Und_Soc_13th_Ed_Mar22\stata\stata13_se\ukhls"

global Working "....SDS....\Working"

// Set Log files //

log using "$Logfiles\SecureUKHLS_Analysis.log", replace

/* Logfile saves all results that pass through window to the log
to give a complete record of the session (both syntax and output) which can be used
to check that the syntax has worked as expected. */

/******************************************************************************/
		  
/*********   ~  MULTILEVEL Model of Newly Diagnosed Conditions  ~    **********/

*******************************************************************************/	

	// Declare Data to be Panel Data (time (year) within Individual)
	
	// Stopped at Wave 9 due to change in Newly Diagnosed variable to "ever diagnosed" in Wave 10
	

cd "$Working" 

use "$Working\_KEY_files\QAd_LINKED_GP_Hosp_27sept2022.dta"


xtset pidp wave, yearly 

/*       panel variable:  pidp (unbalanced) 
        time variable:  wave 
                delta:  1 year */


/******************************************************************************/
		  
/*****  ~  New_Diag3 Treated as Ordinal (zero to two or more conditions)  ~  ****/

*******************************************************************************/	

/***************************  New_Diag3  **************************************/
  

tab REGION_num 
  
  // North/South/Wales not relevant
  
cd "$Working/DRAFT_Final/"
  
   // 1. NULL MODEL with Constant then CRU_num added  LL (Log psuedoLikelihood) MORE significant once "missing" recoded
   
   // NULL Model coefficient more than 3x Stdrd Err so looks significant
  
meologit New_Diag3 ib16.CRU_num if wave < 10 & New_Diag3 !=. [pweight = indinus_lw9] || CRU_num: R.psu, vce(cluster CRU_num) 

estimates store NewDiag3_Model_1_a

estout // check model results stored

// esttab * using "Model1.csv", csv  // To save an initial model
  
  // 2. Sex & Age interaction; 

 meologit New_Diag3 i.sex age_dv age_sq i.sex#c.age_dv   if wave < 10 [pweight = indinus_lw9] || CRU_num: R.psu, vce(cluster CRU_num) 
estimates store NewDiag3_Model_1_b

	// 3. Chronic (Long-term)  "impairment, illness or disability... 12 months or longer"  health variable;  
	
	// Men slightly more likely to get new diagnosis than women when interacted with age

meologit New_Diag3 i.sex age_dv age_sq i.CHRONIC#c.age_dv if wave < 10 [pweight = indinus_lw9] || CRU_num: R.psu, vce(cluster CRU_num)

estimates store NewDiag3_Model_1_c

	// 4. Change interaction with age_dv to age_squared to see if this improves the model  

meologit New_Diag3 i.sex age_dv i.sex#i.CHRONIC c.age_dv#i.CHRONIC if wave < 10 [pweight = indinus_lw9] || CRU_num: R.psu, vce(cluster CRU_num) 

estimates store NewDiag3_Model_1_d

  // 5. GP_Dist not  significant   [GP_dis_sq and Hosp_dist even less so...]     - N0 significant Change in LL (three or more is minimum)
  
meologit New_Diag3 i.sex age_dv i.CHRONIC#i.sex i.CHRONIC#c.age_dv GP_Dist if wave < 10 [pweight = indinus_lw9] || CRU_num: R.psu, vce(cluster CRU_num) 

estimates store NewDiag3_Model_1_e
	
	// 6. Housing Tenure added to the model  >>   SIGINIFICANT REDUCTION
	
 meologit New_Diag3 i.sex age_dv age_sq i.CHRONIC#c.age_dv i.sex#i.CHRONIC ib16.CRU_num  if wave < 10 [pweight = indinus_lw9] || CRU_num: R.psu, vce(cluster CRU_num) 
 
 estimates store NewDiag3_Model_1_f
 
 
 // 7. Housing TENURE Makes a MASSIVE Difference in Log pseudolikelihood   
  
  // ib3.REGION_num
  
 meologit New_Diag3 i.sex age_dv age_sq i.CHRONIC#c.age_dv i.Tenure_3 c.GP_Dist#ib3.nr_Cars3 if wave < 10 [pweight = indinus_lw9] || CRU_num: R.psu, vce(cluster CRU_num) // Log pseudolikelihood = -29111  
 
estimates store NewDiag3_Model_1_g
 
 
 // NEW VAR tried >> 
 //gen hhequiv_cars = numCars5 /ieqmoecd_dv  // Household cars, equivalised
 
 
 // 8.  Allowing for Age & Tenure Effect as older people more likely to own, younger more likely to rent privately etc  ;  
 
 meologit New_Diag3 i.sex age_dv age_sq i.sex#i.CHRONIC c.age_dv#CHRONIC  i.Tenure_3 i.Diabetes c.age_dv#ib1.CRU_num  i.LonePar_2 if wave < 10 [pweight = indinus_lw9] || CRU_num: R.psu, vce(cluster CRU_num) 
 
  estimates store NewDiag3_Model_1_h
  
  // 
 
 /******************************************************************************/

/*********  ~  Newly Diagnosed Conditions - New_Diag3 (Ordinal categories)  ~  ************/

*******************************************************************************/
    
  // eform is exponentiated
  // s  is the statistics (chi-squared, probability, log pseudolikelihoo, Akaike Info Criterion, Bayesian Info Criterion )
  // nopa is "no parentheses" i.e. don't put things in brackets
  // plain (b3) not allowed
  
  
esttab  NewDiag3_Model_1_a  NewDiag3_Model_1_b  NewDiag3_Model_1_c  NewDiag3_Model_1_d  NewDiag3_Model_1_e  NewDiag3_Model_1_f  NewDiag3_Model_1_g NewDiag3_Model_1_h using "NewDiag3_Model_1.csv", replace eform constant star(* 0.05  ** 0.01  *** 0.001) nopa not s(chi2 p ll N aic bic, fmt(%9.3f %9.0g)) csv // double-checked format

//replace eform plain (b3) constant star(* 0.05  ** 0.01  *** 0.001) nopa not s(chi2 p ll N aic bic, fmt(%9.3f %9.0g)) csv


log close