
/******************************************************************************/

/******* ~  Multilevel Modelling of hl2hop  vars  ~  ******************/

/***************************************************************************

	Stata:   WAVES (a - k)
	
					Last Refined 12th OCT 2022
	
	By Sue Easton, LIIRH, University of Lincoln

	UKDS Project Number: 219223
	
	UKDS Study Number SN6614 (UKHLS, All Waves, 2009-2020)
	
	Understanding Society Fellowship
	
***************************************************************************/

/********************  ~    KEY VARIABLES    ~   ***************************/

/**************************************************************************

		//  hl2hop - approx. nr visits to Hospital Outpatients in last year
		//  ORDINAL variable - categroies are grouped: None, one-two; three-five etc
		
		// NB These Variables were only asked from Wave g - k
		// Only survey participants from wave 1 onwards in sample (as per original research question - required for Health analysis)

***************************************************************************/

// Creating directory paths 


global Logfiles ".....SDS....Working\STATA_LogFiles"

global Originals "....SDS....\stata\6676_Und_Soc_13th_Ed_Mar22\stata\stata13_se\ukhls"

global Working "....SDS....\Working"

// Set Log files //

log using "$Logfiles\SecureUKHLS_Analysis.log", replace

/* Logfile saves all results that pass through window to the log
to give a complete record of the session (both syntax and output) which can be used
to check that the syntax has worked as expected. */

/******************************************************************************/
		  
/*****   ~  Ordinal Multilevel Models as Categories Approximate + Recall ~   ************/

*******************************************************************************/	

cd "$Working"

use "$Working\_KEY_files\QAd_LINKED_GP_Hosp_27sept2022.dta", replace

// gen wave_711 = wave if wave >6

xtset pidp wave, yearly  // Declare data to be panel data (years within individual)

	/**************************  ALL MODELS  > 50 YEARS of AGE  ***********************/

	// NULL Model with just CRU Clusters;   

meologit hl2hop__ ib16.CRU_num   if wave > 6  & age_dv > 50 [pweight = indinus_lw11] || CRU_num: R.psu, vce(cluster CRU_num)

estimates store Hl2op_Model_2_a


	//  With age, sex, Chronic/Long-term Health problem/Disab & GP_Dist
	
	// SEx not significant in FIRST MODEL - checked 12 OCT 2022

meologit hl2hop__ age_dv i.CHRONIC i.sex  ib16.CRU_num GP_Dist if wave > 6 & age_dv > 50 [pweight = indinus_lw11] || CRU_num: R.psu, vce(cluster CRU_num)

estimates store Hl2op_Model_2_b

	// North_South NOT RELEVANT  

meologit hl2hop__ age_dv i.CHRONIC#i.sex ib16.CRU_num ib2.North_Sth if wave > 6 & age_dv > 50 [pweight = indinus_lw11] || CRU_num: R.psu, vce(cluster CRU_num)


estimates store Hl2op_Model_2_c

   // *** Wales_dum added   - LESS Significant!!! ***

meologit hl2hop__  age_dv i.sex#i.CHRONIC i.sex  Wales_dum GP_Dist  if wave > 6 & age_dv > 50 [pweight = indinus_lw11] || CRU_num: R.psu, vce(cluster CRU_num)

estimates store  Hl2op_Model_2_d

//ib15.CRU_num     TENURE Not Significant

meologit hl2hop__  age_dv i.sex#i.CHRONIC i.sex c.age_dv#i.sex Wales_dum ib16.CRU_num i.Tenure_3 if wave > 6 & age_dv > 50 [pweight = indinus_lw11] || CRU_num: R.psu, vce(cluster CRU_num)

estimates store  Hl2op_Model_2_e


// GP Distance becomes significant

meologit hl2hop__  age_dv i.sex#i.CHRONIC i.sex c.age_dv#i.sex Wales_dum c.age_dv#ib16.CRU_num  GP_Dist if wave > 6 & age_dv > 50 [pweight = indinus_lw11] || CRU_num: R.psu, vce(cluster CRU_num)

estimates store  Hl2op_Model_2_f

// Tried gPdist Sq - NOT Significant

// Too many interactions with Sex/Gender?

meologit hl2hop__  age_dv i.sex#i.CHRONIC i.sex c.age_dv#i.sex Wales_dum c.age_dv#ib16.CRU_num i.sex#c.GP_Dist  if wave > 6 & age_dv > 50 [pweight = indinus_lw11] || CRU_num: R.psu, vce(cluster CRU_num)

estimates store  Hl2op_Model_2_g


//  *** REGIONS - Significant  ***   

meologit hl2hop__  i.sex#c.age_dv c.age_dv#i.CHRONIC i.sex#c.age_dv ib3.REGION_num c.age_dv#ib16.CRU_num i.sex#c.GP_Dist if wave > 6 & age_dv > 50 [pweight = indinus_lw11] || CRU_num: R.psu, vce(cluster CRU_num)

estimates store  Hl2op_Model_2_h


// GP Distance STILL significant if ALL AGES included		

// GP dist Squared SIGNIFICANT

meologit hl2hop__  age_dv age_sq i.sex#i.CHRONIC Diabetes i.sex#c.GP_Dist c.age_dv#ib16.CRU_num i.Tenure_3  i.Wales_dum if age_dv > 50 & wave > 6 [pweight = indinus_lw11] || CRU_num: R.psu, vce(cluster CRU_num)

estimates store  Hl2op_Model_2_i

// GP Distance not significant if ALL AGES included, UNLESS with *** Wales_dum ***

meologit hl2hop__  age_dv age_sq i.sex#i.CHRONIC Diabetes i.sex#c.GP_Dist c.age_dv#ib16.CRU_num  i.Tenure_3  if wave > 6 [pweight = indinus_lw11] || CRU_num: R.psu, vce(cluster CRU_num)

estimates store  Hl2op_Model_2_j




/**************************** ~~~  hl2hop Model ~~~  *****************************/
  
esttab   Hl2op_Model_2_a   Hl2op_Model_2_b   Hl2op_Model_2_c   Hl2op_Model_2_d   Hl2op_Model_2_e   Hl2op_Model_2_f   Hl2op_Model_2_g   Hl2op_Model_2_h   Hl2op_Model_2_i Hl2op_Model_2_j using Hl2op_Model_2.csv, replace eform constant star(* 0.05  ** 0.01  *** 0.001) nopa not s(chi2 p ll N aic bic, fmt(%9.3f %9.0g)) csv