
/******************************************************************************/

/******* ~  Multilevel Modelling of hl2gp vars  ~  ******************/

/***************************************************************************

	Stata:   WAVES (a - k)
	
					REVISED 22nd JULY 2022
	
	By Sue Easton, LIIRH, University of Lincoln

	UKDS Project Number: 219223
	
	UKDS Study Number SN6614 (UKHLS, All Waves, 2009-2020)
	
	Understanding Society Fellowship
	
***************************************************************************/

/********************  ~    KEY VARIABLES    ~   ***************************/

/**************************************************************************

		//  hl2gp  - approx. number of visits to GP in last year
		// ORDINAL variable - categroies are grouped: None, one-two; three to five etc
		
		// NB These Variables were only asked from Wave g - k
		
		// Only survey participants from wave 1 onwards in sample (as per original research question - required for Health analysis)
	
***************************************************************************/

// Creating directory paths -

global Logfiles ".....SDS....Working\STATA_LogFiles"

global Originals "....SDS....\stata\6676_Und_Soc_13th_Ed_Mar22\stata\stata13_se\ukhls"

global Working "....SDS....\Working"

// Set Log files //

log using "$Logfiles\SecureUKHLS_Analysis.log", replace


/* Logfile saves all results that pass through window to the log
to give a complete record of the session (both syntax and output) which can be used
to check that the syntax has worked as expected. */

/******************************************************************************/
		  
/*****   ~  Ordinal Multilevel Models as Categories Approximate + Recall ~   ************/

*******************************************************************************/	

cd "$Working"

// use "$Working/  RELEVANT DATA FILE

xtset pidp wave, yearly  // Declare data to be panel data (years within individual)

	// NULL Model with just CRU Clusters   

meologit hl2gp__ ib16.CRU_num   if wave > 6 [pweight = indinus_lw11] || CRU_num: R.psu, vce(cluster CRU_num)

estimates store Hl2gp_Model_3_a


	//  With age, sex, Chronic/Long-term Health problem.Disabiliity & GP_Dist;  

meologit hl2gp__ age_dv i.CHRONIC i.sex GP_Dist ib2.North_Sth if wave > 6 & CHRONIC !=. [pweight = indinus_lw11] || CRU_num: R.psu, vce(cluster CRU_num)

estimates store Hl2gp_Model_3_b


	// REGION added;   Log Likelihood 

meologit hl2gp__ age_dv i.sex i.CHRONIC#i.Diabetes GP_Dist ib16.CRU_num  if wave > 6 & CHRONIC !=. [pweight = indinus_lw11] || CRU_num: R.psu, vce(cluster CRU_num)


estimates store Hl2gp_Model_3_c

   //  HOUSING Tenure Added;   

meologit hl2gp__ age_dv  i.sex  i.sex#i.CHRONIC i.Diabetes ib16.CRU_num  i.Tenure_3 if wave > 6 & CHRONIC !=. [pweight = indinus_lw11] || CRU_num: R.psu, vce(cluster CRU_num)

estimates store Hl2gp_Model_3_d

	// TENURE & CRU_Classifcn   

meologit hl2gp__ age_dv  i.sex  i.sex#i.CHRONIC i.Diabetes  i.Tenure_3 ib16.CRU_num    if wave > 6 & CHRONIC !=.  [pweight = indinus_lw11] || CRU_num: R.psu, vce(cluster CRU_num)

	// TENURE & CRU_Classifcn  
	
	//  age*SEx interaction - Older Females LESS likely to visit their GP?  //

meologit hl2gp__ age_dv  i.sex  i.sex#i.CHRONIC  i.Tenure_3 ib16.CRU_num  i.sex#c.GP_Dist ib5.REGION_num   if wave > 6 & CHRONIC !=.  [pweight = indinus_lw11] || CRU_num: R.psu, vce(cluster CRU_num)

estimates store Hl2gp_Model_3_e


// TENURE & CRU_Classifcn    //  

meologit hl2gp__ age_dv i.sex  i.sex#c.age_dv i.sex#i.CHRONIC  i.Tenure_3 c.age_dv#ib16.CRU_num  i.sex#c.GP_Dist   if wave > 6 & CHRONIC !=.   [pweight = indinus_lw11] || CRU_num: R.psu, vce(cluster CRU_num)

estimates store Hl2gp_Model_3_f


  /******************  hl2gp Model  *****************************************/
  
esttab  Hl2gp_Model_3_a   Hl2gp_Model_3_b   Hl2gp_Model_3_c   Hl2gp_Model_3_d  Hl2gp_Model_3_e Hl2gp_Model_3_f using Hl2gp_Model_3.csv, replace eform constant star(* 0.05  ** 0.01  *** 0.001) nopa not s(chi2 p ll N aic bic, fmt(%9.3f %9.0g)) csv